package activities.api;

import activities.dto.modeldto.ActivityDefinitionDto;

import java.util.List;

/**
 * Created by renjunlin on 2017/7/4.
 */

public interface ActivityApi {

    /**
     * 根据渠道id活动id查询活动
     * @param organizationCode
     * @param activityCode
     * @return
     */
    public ActivityDefinitionDto findByOrganizationCodeAndActivityCode(String organizationCode, String activityCode);
    /**
     * 根据渠道id，活动id，活动时间升序，活动状态在线，查询秒杀活动
     * @param organizationCode
     * @param activityCode
     * @return
     */
    List<ActivityDefinitionDto> findSecKillActivity(String organizationCode, String activityCode);
    /**
     * 根据活动定义id查询秒杀活动
     * @param id
     * @return
     */
    ActivityDefinitionDto findById(String id);

    /**
     * 用户是否参加活动并成功下单
     */
    boolean hasEffectiveOrder(String memberId, String activtyId);
    /**
     * 场次结束置为失效状态
     */
    void setActivityDefinitionIsOnline(String activtyId);

    ActivityDefinitionDto findByOrganizationCode(String organizationCode,String ctAtivityCode);

    /**
     * 根据样例数据查询活动场次
     *
     * @param activityDefinitionDto activityDefinitionDto
     * @return  List<ActivityDefinitionDto>
     */
    List<ActivityDefinitionDto> findByExample(ActivityDefinitionDto activityDefinitionDto);

    /**
     * 保存或更新
     *
     * @param activityDefinitionDto ActivityDefinitionDto
     * @return ActivityDefinitionDto
     */
    ActivityDefinitionDto saveOrUpdate(ActivityDefinitionDto activityDefinitionDto);
}
