package activities.api;

import activities.definition.ActivityDefinitionType;
import activities.dto.activity.request.ActivityGoodsReqDto;
import activities.dto.activity.response.ActivityGoodsRespDto;
import activities.dto.goods.GoodsDto;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.ActivityGoodsDto;
import activities.vo.ActivityVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * Created by oracle on 2017-07-10.
 */
public interface ActivityGoodsApi {
    /**
     * 批量判断商品是否是活动商品并获取活动价
     * isActivityGoods true 是活动商品
     * activityPrice 活动价，非活动商品该值不返回
     *
     * @param goodses
     * @param organizationCode
     * @return
     */
    public List<Map<String, Object>> isActivityGoodsAndGetActivityPriceBatch(List<GoodsDto> goodses, String organizationCode);

    /**
     * 判断商品是否是活动商品并获取活动价
     * <p>
     * activityId 活动id
     * isActivityGoods true 是活动商品
     * activityPrice 活动价，非活动商品该值不返回
     *
     * @param goods
     * @param OrganizationCode
     * @return
     */
    @Deprecated
    public Map<String, Object> isActivityGoodsAndGetActivityPrice(GoodsDto goods, String OrganizationCode);

    public ActivityGoodsRespDto isActivityGoodsAndGetActivityPrice(ActivityGoodsReqDto activityGoodsReqDto);


    public void increamentSaleCount(String activityDefinitionId, String goodsId, Integer buyCount);


    /**
     * 根据商品ID获取活动商品
     *
     * @param goodsId    商品ID
     * @param activityId 活动ID
     * @return 活动商品
     */
    List<ActivityGoodsDto> findActivityGoodsByGoodsIdAndActivityId(String goodsId, String activityId);

    /**
     * 活动商品减库存
     *
     * @param goodsId    当前活动商品ID
     * @param activityId 当前活动ID
     * @param count      占用库存数
     * @return 成功返回true, 失败返回false
     */
    boolean changeActivityGoodsStock(String goodsId, String activityId, int count);

    /**
     * 从缓存中获取当前活动商品所属场次ID
     *
     * @param goodsId      当前活动商品ID
     * @param activityCode 活动代码
     * @return 当前活动商品所属场次ID
     * @return 活动商品库存
     */
    int getCurrentActivityGoodsStockFromCache(String organizationCode, String goodsId, String activityId, String activityCode);


    /**
     * 获得活动商品价格
     *
     * @param goodsId          参与活动的商品ID
     * @param organizationCode 机构代码
     * @param storeCode        商店代码
     * @return 如果传入的goodsId是活动商品ID则返回活动价格，否则返回普通售卖价格
     */
    BigDecimal getActivityPrice(String goodsId, String organizationCode, String storeCode);

    /**
     * 获得活动场次有效订单数
     *
     * @param memberId   用户ID
     * @param activityId 活动场次ID
     * @return 有效订单数量
     */
    BigDecimal getEffectiveOrderCount(String memberId, String activityId);

    /**
     * 改变活动商品库存以及售出数量
     *
     * @param activityId 活动ID
     * @param goodsId    参与活动的商品ID
     * @param buyNum     购买数量
     */
    void increamentSoldNumAndStockNum(String activityId, String goodsId, Integer buyNum);

    /**
     * 反活动商品库存
     *
     * @param goodsId          参与活动的商品ID
     * @param activityId       活动ID
     * @param count            返还库存数量
     * @param organizationCode 机构代码
     */
    void backActivityGoodsStockAndSolcNum(String goodsId, String activityId, Integer count, String organizationCode);

    /**
     * 是否场次限制
     *
     * @param memberId     用户ID
     * @param activityId   活动场次ID
     * @param limitedCount 限制数量
     * @return
     */
    boolean isActivityLimited(String memberId, String activityId, int limitedCount);

    /**
     * 获取活动状态
     *
     * @param activityDefinition
     * @return
     */
    public ActivityDefinitionType getActivityDefinitionType(ActivityDefinitionDto activityDefinition);

    List<ActivityGoodsDto> findByGiftClass(String giftClass,String activityDefinitionId);

    public ActivityGoodsDto saveActivityGoods(ActivityGoodsDto activityGoodsDto);

    /**
     * 是否商品当前处于活动期间
     * @param goodsId 商品ID
     * @param organizationCode 机构代码
     * @return 如果处于活动期间, 则返回活动场次ID, 否则返回 null
     */
    String isInActivityNow(String goodsId, String organizationCode);

    /**
     * 批量设置活动商品售价
     * @param activityVoList List<ActivityVo>
     * @param organizationCode 机构代码
     * @param storeCode 店铺代码
     */
    void setActivityPrice(List<ActivityVo> activityVoList, String organizationCode, String storeCode);

    /**
     * 根据样例数据获取活动商品列表
     *
     * @param activityGoodsExample ActivityGoodsDto
     * @return List<ActivityGoodsDto>
     */
    List<ActivityGoodsDto> findByExample(ActivityGoodsDto activityGoodsExample);

    /**
     * 检查缓存库存
     *
     * @param organizationCode 机构代码
     * @param activityId 活动场次 ID
     * @param activityCode 活动代码
     * @param goodsId 商品 ID
     * @param count 购买数量
     * @return 库存足够返回 true, 否则返回 false
     */
    boolean checkCacheStock(String organizationCode, String activityId, String activityCode, String goodsId, Integer count);
}
