package activities.api;

import activities.dto.activity.request.OrderRequstVo;
import activities.dto.activity.response.OrderResponseVo;
import activities.dto.groupbuying.request.*;
import activities.dto.groupbuying.response.*;
import activities.vo.payment.PaymentReturnVo;
import sinomall.config.api.base.BaseResponse;

/**
 * 拼团api
 */

public interface GroupBuyingApi {
    final static String GROUP_REDIS_KEY = "ACTIVITY:PINGTUAN:LOCK:";

    /**
     * 查询拼团商品价格
     *
     * @param groupBuyingGoodsReqDto
     * @return
     */
    public GroupBuyingGoodsRespDto queryGroupBuyingGoodsPrice(GroupBuyingGoodsReqDto groupBuyingGoodsReqDto);

    /**
     * 查询团信息
     *
     * @param gbGroupInfoReqDto
     * @return
     */
    public GbGroupInfoRespDto queryGbGroupInfo(GbGroupInfoReqDto gbGroupInfoReqDto);

    /**
     * 查询活动信息
     */
    public GbActivityInfoRespDto queryGbActivityInfoById(GbActivityInfoReqDto gbActivityInfoReqDto);

    /**
     * 根据活动或团查询参团数量以及是否做过此活动团长
     *
     * @param gbGroupJoinReqDto
     * @return
     */
    public GbGroupJoinRespDto queryGbGroupJoinNumber(GbGroupJoinReqDto gbGroupJoinReqDto);

    /**
     * 拼团活动创建订单
     *
     * @param orderRequstVo
     * @return
     */
    public OrderResponseVo createOrder(OrderRequstVo orderRequstVo);

    /**
     * 处理拼团团信息，根据购买方式创建新团或
     *
     * @param hanleGroupRequestDto
     * @return
     */
    public GroupInfoHandleResponseDto handleGroupInfo(GroupInfoHandleRequestDto hanleGroupRequestDto);

    /**
     * 取消拼团订单
     *
     * @param orderNo
     * @return
     */
    public BaseResponse cancelGbOrder(String orderNo);

    /**
     * 拼团支付回调
     *
     * @param paymentReturnVo
     * @return
     */
    public BaseResponse gbPayback(PaymentReturnVo paymentReturnVo);

    GbOrderInfoDto queryGroupOrderInfo(String orderNo);

    String findOrderNoByMemberIdAndGroupId(String memberId, String groupId);
    /**
     * 定时扫描处理过期未成团的团
     * */
    void queryActivityGroupStatusAndHandle();
}
