package activities.definition;

import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * 活动代码枚举
 *
 * @author Drury
 */
public enum ActivityCode {

    /**
     * 秒杀
     */
    SEC_KILL("seckill", "秒杀"),

    /**
     * 团购
     */
    TUAN_GOU("tuangou", "团购"),

    /**
     * 充值中心
     */
    VOUCHER_CENTER("voucherCenter", "充值中心");

    /**
     * 代码
     */
    @Getter
    @Setter
    private String code;

    /**
     * 描述
     */
    @Getter
    @Setter
    private String description;

    ActivityCode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 枚举集合
     * key =  活动代码
     * value = 活动代码枚举举对象
     */
    public static Map<String, ActivityCode> activityCodeMap = new HashMap<>();

    static {
        activityCodeMap.put(SEC_KILL.getCode(), SEC_KILL);
        activityCodeMap.put(TUAN_GOU.getCode(), TUAN_GOU);
        activityCodeMap.put(VOUCHER_CENTER.getCode(), VOUCHER_CENTER);
    }

}
