package activities.definition;

import java.util.HashMap;
import java.util.Map;

public enum ActivityDefinitionType {
    beforeStart("0", "未开始"), onGoing("1", "进行中"), end("2", "已结束"), noExist("3", "不存在");
    private String code;
    private String description;
    public static Map<String, ActivityDefinitionType> activityDefinitionTypeMap = new HashMap<>();

    static {
        activityDefinitionTypeMap.put(beforeStart.getCode(), beforeStart);
        activityDefinitionTypeMap.put(onGoing.getCode(), onGoing);
        activityDefinitionTypeMap.put(end.getCode(), end);
        activityDefinitionTypeMap.put(noExist.getCode(), noExist);
    }

    ActivityDefinitionType() {
    }

    ActivityDefinitionType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
