package activities.definition;

import java.util.HashMap;
import java.util.Map;

public enum ActivityPriceType {
    ratePrcie("0", "费率价"), negotiatedPrice("1", "协议价"), configurationPrice("2", "配置固定价");
    private String code;
    private String description;
    public static Map<String, ActivityPriceType> activityPriceTypeMap = new HashMap<>();

    static {
        activityPriceTypeMap.put(ratePrcie.getCode(), ratePrcie);
        activityPriceTypeMap.put(negotiatedPrice.getCode(), negotiatedPrice);
        activityPriceTypeMap.put(configurationPrice.getCode(), configurationPrice);
    }

    ActivityPriceType() {
    }

    ActivityPriceType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
