package activities.definition;

import java.util.HashMap;
import java.util.Map;
/**
 * 定义已过期且已确认预占库存的活动
 * */
public enum GbActivityStatus {
    noExpiredSynchronize("0", "活动过期未同步"), expiredSynchronize("1", "活动过期已同步");
    private String code;
    private String description;
    public static Map<String, GbActivityStatus> gbActivityStatusHashMap = new HashMap<>();
    static {
        gbActivityStatusHashMap.put(noExpiredSynchronize.getCode(),noExpiredSynchronize);
        gbActivityStatusHashMap.put(expiredSynchronize.getCode(),expiredSynchronize);
    }
    GbActivityStatus(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
