package activities.dto.goods;


import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2016/9/29.
 * 商品扩展属性表
 * 用于存储商品特殊的信息
 */
public class GoodsAttrDto extends BaseDomainDto implements Serializable {

    public static String VIRTUAL_GOODS = "VIRTUAL_GOODS";
    public static String VIRTUAL_GOODS_FLGCARDS = "VIRTUAL_GOODS_FLGCARDS";
    public static String ATTR_VIETUAL_JDEK = "ATTR_VIETUAL_JDEK";
    public static String ATTR_VIETUAL_TIXIAN = "TIXIAN";
    public static String ATTR_VIETUAL_AMAZON = "VIETUAL_AMAZON";
    public static String ATTR_VIETUAL_XCRWX = "VIETUAL_XCRWX";
    public static String ATTR_VIETUAL_HFCZ = "VIETUAL_HFCZ";
    public static String ATTR_VIETUAL_LLCZ = "VIETUAL_LLCZ";
    public static String ATTR_VIETUAL_JYKCZ = "VIETUAL_JYKCZ";
    public static String ATTR_VIETUAL_DYP = "VIETUAL_DYP";
    public static Map<String, Object> attrs = new HashMap<>();

    static {
        attrs.put(VIRTUAL_GOODS, "虚拟产品");
        attrs.put(VIRTUAL_GOODS_FLGCARDS, "福利高卡券");
        attrs.put(ATTR_VIETUAL_JDEK, "京东e卡");
        attrs.put(ATTR_VIETUAL_TIXIAN, "兑E卡可转让");
        attrs.put(ATTR_VIETUAL_AMAZON, "亚马逊电子卡");
        attrs.put(ATTR_VIETUAL_XCRWX, "携程任我行电子卡");
        attrs.put(ATTR_VIETUAL_HFCZ, "话费充值");
        attrs.put(ATTR_VIETUAL_LLCZ, "流量充值");
        attrs.put(ATTR_VIETUAL_JYKCZ, "加油卡充值");
        attrs.put(ATTR_VIETUAL_DYP, "电影票");
    }

    private String id;

    /**
     * 商品扩展属性名称
     */
    private String attrName;

    /**
     * 商品扩展属性值
     */
    private String attrValue;

    private GoodsDto goods;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GoodsAttrDto goodsAttr = (GoodsAttrDto) o;

        return id != null ? id.equals(goodsAttr.id) : goodsAttr.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAttrName() {
        return attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    public String getAttrValue() {
        return attrValue;
    }

    public void setAttrValue(String attrValue) {
        this.attrValue = attrValue;
    }

    public GoodsDto getGoods() {
        return goods;
    }

    public void setGoods(GoodsDto goods) {
        this.goods = goods;
    }
}
