package activities.dto.goods;

import com.alibaba.fastjson.annotation.JSONField;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by Roney on 2016/9/29.
 * 商品   先选择产品
 */
public class GoodsDto extends BaseDomainDto implements Serializable {
    //3
    public GoodsDto() {

    }

    public GoodsDto(String storeId, Integer state) {
        this.storeId = storeId;
        this.state = state;
    }

    public GoodsDto(String id, String storeId, Integer state) {
        this.id = id;
        this.storeId = storeId;
        this.state = state;
    }

    private String id;


    /**
     * 商品名称
     */
    private String name;

    /**
     * 产品ID
     */
    private ProductDto product;

    /**
     * 商品的标题
     */
    private String title;

    /**
     * 商品CODE值
    */
    private String code;

    /**
     * 搜索关键词
     */
    private String keyword;

    /**
     * 门店ID
     */
    private String storeId;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 出售价格
     */
    private BigDecimal salePrice;

    /**
     * 成本价（进货价、第三方协议价）
     */
    private BigDecimal costPrice;

    /**
     * 浏览次数
     */
    private Long viewCount;

    /**
     * 销售次数
     */
    private Long saleCount;

    /**
     * 库存数量
     */

    private Long stockCount;


    /**
     * 销售状态
     */
    private Boolean onSale;

    /**
     * 商品介绍
     */
    private String introduction;

    /**
     * 商品规格参数
     */
    private String param;

    /**
     * 第三方品牌名称
     */
    private String brandName;

    /**
     * 产地
     */
    private String productArea;

    /**
     * 销售单位
     */
    private String saleUnit;

    /**
     * 外部商品编号-（一期为京东）
     */
    private String sku;


    /**
     * 外部商品状态
     * 1 上架	0 下架
     */
    private Integer state;

    /**
     * 上架时间
     */

    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date pushUpDate;

    /**
     * 下架时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date pushDownDate;

    /**
     * 条形码
     */
    private String upc;

    /**
     * 规格描述
     * e: 三菱铁咀涂改笔X12
     */
    private String wareQD;

    /**
     * 商品重量
     */
    private String weight;


    /**
     * 是否是推荐商品
     */
    private Boolean isRecommend;

    /**
     * 是否特价
     */
    private Boolean isSpecial;

    /**
     * 是否热销
     */
    private Boolean isHotsale;

    /**
     * 是否是新产品
     */
    private Boolean isNewProduct;

    /**
     * 积分
     */
    private Long score;

    /**
     * 商品的状态
     * 0 待审核 默认
     * 1审核不通过
     * 2审核通过
     * 3已上架
     * 4已下架
     */
    private Integer status;


    /**
     * 分享内容
     */
    private String shareContent;

    /**
     * 商品详情
     */
    private String goodsDetails;

    /**
     * 售后详情
     */

    private String afterSaleDetails;


    /**
     * 第三方价格折扣率
     */
    private BigDecimal discountRate;

    private String goodsRemarks;

    /**
     * 是否产家配送
     */
    private Boolean isJudgefac;

    private List<GoodsAttrDto> goodsAttrs;

    private List<GoodsPictureDto> goodsPictures;

    private GoodsFashionDto goodsFashions;

    private List<GoodsParamsDto> goodsParams;

    private ProductFashionDto productFashion;

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public String getParam() {
        return param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getProductArea() {
        return productArea;
    }

    public void setProductArea(String productArea) {
        this.productArea = productArea;
    }

    public String getSaleUnit() {
        return saleUnit;
    }

    public void setSaleUnit(String saleUnit) {
        this.saleUnit = saleUnit;
    }

    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getUpc() {
        return upc;
    }

    public void setUpc(String upc) {
        this.upc = upc;
    }

    public String getWareQD() {
        return wareQD;
    }

    public void setWareQD(String wareQD) {
        this.wareQD = wareQD;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public Boolean getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Boolean isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Boolean getIsSpecial() {
        return isSpecial;
    }

    public void setIsSpecial(Boolean isSpecial) {
        this.isSpecial = isSpecial;
    }

    public Boolean getIsHotsale() {
        return isHotsale;
    }

    public void setIsHotsale(Boolean isHotsale) {
        this.isHotsale = isHotsale;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProductDto getProduct() {
        return product;
    }

    public void setProduct(ProductDto product) {
        this.product = product;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(BigDecimal marketPrice) {
        this.marketPrice = marketPrice;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Long getViewCount() {
        return viewCount;
    }

    public void setViewCount(Long viewCount) {
        this.viewCount = viewCount;
    }

    public Long getSaleCount() {
        return saleCount;
    }

    public void setSaleCount(Long saleCount) {
        this.saleCount = saleCount;
    }

    public Long getStockCount() {
        return stockCount;
    }

    public void setStockCount(Long stockCount) {
        this.stockCount = stockCount;
    }

    public Boolean getOnSale() {
        return onSale;
    }

    public void setOnSale(Boolean onSale) {
        this.onSale = onSale;
    }

    public Boolean getRecommend() {
        return isRecommend;
    }

    public void setRecommend(Boolean recommend) {
        isRecommend = recommend;
    }

    public Boolean getSpecial() {
        return isSpecial;
    }

    public void setSpecial(Boolean special) {
        isSpecial = special;
    }

    public Boolean getHotsale() {
        return isHotsale;
    }

    public void setHotsale(Boolean hotsale) {
        isHotsale = hotsale;
    }

    public Boolean getNewProduct() {
        return isNewProduct;
    }

    public void setNewProduct(Boolean newProduct) {
        isNewProduct = newProduct;
    }

    public Long getScore() {
        return score;
    }

    public void setScore(Long score) {
        this.score = score;
    }

    public String getShareContent() {
        return shareContent;
    }

    public void setShareContent(String shareContent) {
        this.shareContent = shareContent;
    }

    public String getGoodsDetails() {
        return goodsDetails;
    }

    public void setGoodsDetails(String goodsDetails) {
        this.goodsDetails = goodsDetails;
    }

    public String getAfterSaleDetails() {
        return afterSaleDetails;
    }

    public void setAfterSaleDetails(String afterSaleDetails) {
        this.afterSaleDetails = afterSaleDetails;
    }

    public List<GoodsAttrDto> getGoodsAttrs() {
        return goodsAttrs;
    }

    public void setGoodsAttrs(List<GoodsAttrDto> goodsAttrs) {
        this.goodsAttrs = goodsAttrs;
    }


    public List<GoodsPictureDto> getGoodsPictures() {
        return goodsPictures;
    }

    public void setGoodsPictures(List<GoodsPictureDto> goodsPictures) {
        this.goodsPictures = goodsPictures;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public GoodsFashionDto getGoodsFashions() {
        return goodsFashions;
    }

    public void setGoodsFashions(GoodsFashionDto goodsFashions) {
        this.goodsFashions = goodsFashions;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getPushUpDate() {
        return pushUpDate;
    }

    public void setPushUpDate(Date pushUpDate) {
        this.pushUpDate = pushUpDate;
    }

    public Date getPushDownDate() {
        return pushDownDate;
    }

    public void setPushDownDate(Date pushDownDate) {
        this.pushDownDate = pushDownDate;
    }

    public List<GoodsParamsDto> getGoodsParams() {
        return goodsParams;
    }

    public void setGoodsParams(List<GoodsParamsDto> goodsParams) {
        this.goodsParams = goodsParams;
    }

    public BigDecimal getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    public String getGoodsRemarks() {
        return goodsRemarks;
    }

    public void setGoodsRemarks(String goodsRemarks) {
        this.goodsRemarks = goodsRemarks;
    }

    public Boolean getJudgefac() {
        return isJudgefac;
    }

    public void setJudgefac(Boolean judgefac) {
        isJudgefac = judgefac;
    }

    public ProductFashionDto getProductFashion() {
        return productFashion;
    }

    public void setProductFashion(ProductFashionDto productFashion) {
        this.productFashion = productFashion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GoodsDto that = (GoodsDto) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}
