package activities.dto.goods;


import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created by Roney on 2016/10/8.
 * 设置规格的扩展
 */

public class GoodsFashionDto extends BaseDomainDto implements Serializable {

    private String id;

    private GoodsDto goods;

    /**
     * 规格ID
     */
    private String productStandardId;

    /**
     * 库存数量
     */
    private Integer stockCount;

    /**
     * 是否在售
     */
    private Boolean onSale;

    private BigDecimal marketPrice;

    private BigDecimal salePrice;

    private BigDecimal costPrice;

    /**
     * 风格
     */
    private String fashionStyle;

    private Integer saleCount;

    /**
     * 产品code
     */
    private String productCode;

    private Integer lackRemind;

    /**
     * 文字
     */
    private String fashionPiction;

    /**
     * 图片
     */
    private String fashionPic;

    /**
     * 颜色
     */
    private String fashionColor;

    /**
     * 大小
     */
    private String fashionSize;

    /**
     * 是否默认
     * <p/>
     * 多种组合只能有一个默认
     * <p/>
     * 同一个goodsID
     */

    private Boolean isDefault;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProductStandardId() {
        return productStandardId;
    }

    public void setProductStandardId(String productStandardId) {
        this.productStandardId = productStandardId;
    }

    public GoodsDto getGoods() {
        return goods;
    }

    public void setGoods(GoodsDto goods) {
        this.goods = goods;
    }

    public Integer getStockCount() {
        return stockCount;
    }

    public void setStockCount(Integer stockCount) {
        this.stockCount = stockCount;
    }

    public Boolean getOnSale() {
        return onSale;
    }

    public void setOnSale(Boolean onSale) {
        this.onSale = onSale;
    }

    public BigDecimal getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(BigDecimal marketPrice) {
        this.marketPrice = marketPrice;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public String getFashionStyle() {
        return fashionStyle;
    }

    public void setFashionStyle(String fashionStyle) {
        this.fashionStyle = fashionStyle;
    }

    public Integer getSaleCount() {
        return saleCount;
    }

    public void setSaleCount(Integer saleCount) {
        this.saleCount = saleCount;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Integer getLackRemind() {
        return lackRemind;
    }

    public void setLackRemind(Integer lackRemind) {
        this.lackRemind = lackRemind;
    }

    public String getFashionPiction() {
        return fashionPiction;
    }

    public void setFashionPiction(String fashionPiction) {
        this.fashionPiction = fashionPiction;
    }

    public String getFashionPic() {
        return fashionPic;
    }

    public void setFashionPic(String fashionPic) {
        this.fashionPic = fashionPic;
    }

    public String getFashionColor() {
        return fashionColor;
    }

    public void setFashionColor(String fashionColor) {
        this.fashionColor = fashionColor;
    }

    public String getFashionSize() {
        return fashionSize;
    }

    public void setFashionSize(String fashionSize) {
        this.fashionSize = fashionSize;
    }

    public Boolean getDefault() {
        return isDefault;
    }

    public void setDefault(Boolean aDefault) {
        isDefault = aDefault;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GoodsFashionDto that = (GoodsFashionDto) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}
