package activities.dto.goods;


import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2016/9/27.
 *
 * 产品的分类
 */
public class ProductCategoryDto extends BaseDomainDto implements Serializable {

    private String id;

    /**
     * 类型名称
     *  */
    private String name;

    /**
     * 类型路径
     *  */
    private String path;

    /**
     * 左经纬度
     */
    private Integer lft;

    /**
     * 右经纬
     */
    private Integer rgt;

    /**
     * 排序值
     */
    private Integer showIndex;

    /**
     * 关键值
     */
    private String keywords;

    /**
     * 描述
     */
    private String description;

    /**
     * tpl 渠道
     * 预留字段
     */
    private String tplChannel;

    /**
     * tpl 内容
     * 预留字段
     * */
    private String tplContent;

    /**
     * 图片路径
     * 预留字段
     *  */
    private String imagePath;

    /**
     * 标题
     *  */
    private String title;

    /**  */
    private Boolean isColorsize;

    /**
     * 开启规格
     */
    private Boolean isOpenstandard;

    /**
     * 所属层级，用于列表排序
     */
    private Integer layerIndex;

    /**
     * 预留字段，可记录第三方分级id
     */
    private Integer code;

    /**
     * 分类是否上架 0 1
     */
    private Integer state;

    /**
     * 分类类型，该字段一级分类有效，用于首页同类商品分类合并展示
     */
    private Integer categoryType;

    private ProductCategoryDto parent;

    private List<ProductCategoryDto> child;

    private ProductModelDto productModel;

    private List<ProductBrandDto> productBrands;

    private List<ProductStandardDto> productStandards;


    private List<ProductExtendPropertyDto> productExtendPropertys;

    /**
     * 来源code
     */
    private String sourceCode;

    private String categoryRemarks;

    public static final String ID ="id";
    public static final String NAME ="name";
    public static final String LAYERINDEX ="layer_index";
    public static final String PARENTID ="parent_id";
    public static final String PARENTNAME ="parent_name";
    public static final String CATEGORYTYPE ="category_type";
    public static final String CATEGORYSOURCE ="category_source";

    public final static String CATEGORY_SOURCE_ONLINE = "ONLINE"; // 线上

    public final static String CATEGORY_SOURCE_LINE = "LINE"; // 线下

    //一级商品分类 类型归属
    public static final Map CATEGORYTYPEMAP =new HashMap();
    static {
        CATEGORYTYPEMAP.put("家用电器类",1);
        CATEGORYTYPEMAP.put("数码类",2);
        CATEGORYTYPEMAP.put("办公类",3);
        CATEGORYTYPEMAP.put("家居类",4);
        CATEGORYTYPEMAP.put("服装类",5);
        CATEGORYTYPEMAP.put("化妆品类",6);
        CATEGORYTYPEMAP.put("奢侈品类",7);
        CATEGORYTYPEMAP.put("饰品类",8);
        CATEGORYTYPEMAP.put("运动户外类",9);
        CATEGORYTYPEMAP.put("鞋靴类",10);
        CATEGORYTYPEMAP.put("汽车类",11);
        CATEGORYTYPEMAP.put("乐器类",12);
        CATEGORYTYPEMAP.put("医药健康类",13);
        CATEGORYTYPEMAP.put("食品类",14);
        CATEGORYTYPEMAP.put("烟酒类",15);
        CATEGORYTYPEMAP.put("图书音像类",16);
        CATEGORYTYPEMAP.put("生活理财类",17);
        CATEGORYTYPEMAP.put("生活旅游类",18);
        CATEGORYTYPEMAP.put("养生保健类",19);
        CATEGORYTYPEMAP.put("宠物生活类",20);
        CATEGORYTYPEMAP.put("家具建材类",21);
        CATEGORYTYPEMAP.put("农用物资类",22);
    }

    public ProductCategoryDto getParent() {
        return parent;
    }

    public void setParent(ProductCategoryDto parent) {
        this.parent = parent;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getLft() {
        return lft;
    }

    public void setLft(Integer lft) {
        this.lft = lft;
    }

    public Integer getRgt() {
        return rgt;
    }

    public void setRgt(Integer rgt) {
        this.rgt = rgt;
    }

    public Integer getShowIndex() {
        return showIndex;
    }

    public void setShowIndex(Integer showIndex) {
        this.showIndex = showIndex;
    }

    public ProductModelDto getProductModel() {
        return productModel;
    }

    public void setProductModel(ProductModelDto productModel) {
        this.productModel = productModel;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTplChannel() {
        return tplChannel;
    }

    public void setTplChannel(String tplChannel) {
        this.tplChannel = tplChannel;
    }

    public String getTplContent() {
        return tplContent;
    }

    public void setTplContent(String tplContent) {
        this.tplContent = tplContent;
    }

    public String getImagePath() {
        return imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Boolean getColorsize() {
        return isColorsize;
    }

    public void setColorsize(Boolean colorsize) {
        isColorsize = colorsize;
    }

    public Boolean getOpenstandard() {
        return isOpenstandard;
    }

    public void setOpenstandard(Boolean openstandard) {
        isOpenstandard = openstandard;
    }

    public Integer getLayerIndex() {
        return layerIndex;
    }

    public void setLayerIndex(Integer layerIndex) {
        this.layerIndex = layerIndex;
    }

    public Integer getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(Integer categoryType) {
        this.categoryType = categoryType;
    }

    public List<ProductCategoryDto> getChild() {
        return child;
    }

    public void setChild(List<ProductCategoryDto> child) {
        this.child = child;
    }

    public List<ProductBrandDto> getProductBrands() {
        return productBrands;
    }

    public void setProductBrands(List<ProductBrandDto> productBrands) {
        this.productBrands = productBrands;
    }

    public List<ProductStandardDto> getProductStandards() {
        return productStandards;
    }

    public void setProductStandards(List<ProductStandardDto> productStandards) {
        this.productStandards = productStandards;
    }

    public List<ProductExtendPropertyDto> getProductExtendPropertys() {
        return productExtendPropertys;
    }

    public void setProductExtendPropertys(List<ProductExtendPropertyDto> productExtendPropertys) {
        this.productExtendPropertys = productExtendPropertys;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getCategoryRemarks() {
        return categoryRemarks;
    }

    public void setCategoryRemarks(String categoryRemarks) {
        this.categoryRemarks = categoryRemarks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ProductCategoryDto category = (ProductCategoryDto) o;

        return id != null ? id.equals(category.id) : category.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}
