package activities.dto.goods;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by Roney on 2016/9/29.
 * <p>
 * 产品
 */
public class ProductDto extends BaseDomainDto implements Serializable{
    /**
     * 产品类型{@value}: 商品
     */
    public static final String PRODUCT_TYPE_MERCHANDISE = "1";
    /**
     * 产品类型{@value}: 配件
     */
    public static final String PRODUCT_TYPE_FITTING = "2";
    /**
     * 产品类型{@value}: 赠品
     */
    public static final String PRODUCT_TYPE_GIFT = "3";


    private String id;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 店铺ID
     * 一期默认是京东
     */
    private String storeId;


    /**
     * 标题
     */
    private String title;

    /**
     * code值
     * 预留字段
     */
    private String code;

    /**
     * 商品类型 1-商品，2-附件，3-赠品
     */
    private String type;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 销售价
     */
    private BigDecimal salePrice;

    /**
     * 价格
     */
    private BigDecimal costPrice;

    /**
     * 销售数量
     */
    private Integer saleCount = 0;

    /**
     * 销售单位
     */
    private String saleUnit;

    /**
     * 销售状态
     */
    private String saleStatus;

    /**
     * 上下架状态
     */
    private String updownStatus;

    /**
     * 商品审核状态
     */
    private String auditStatus;

    /**
     * 条形码
     */
    private String upc;

    /**
     * 是否是推荐商品
     */
    private Boolean recommendFlag = false;

    /**
     * 是否特价
     */
    private Boolean specialFlag = false;

    /**
     * 是否热销
     */
    private Boolean hotsale = false;

    /**
     * 是否是新产品
     */
    private Boolean newProduct = false;

    /**
     * 售后详情
     */
    private String afterSaleDetails;

    //1:1
    /**
     * 排序
     */
    private Integer showIndex;

    /**
     * 父级关联产品
     */
    private List<ProductDto> parents;

    /**
     * 从属关联产品列表
     */
    private List<ProductDto> children;

    /**
     * 商品规格
     */
    private List<ProductStandardDto> productStandards;

    /**
     * 产品分类
     */
    private ProductCategoryDto productCategory;

    private List<GoodsDto> goodses;

    /**
     * 产品扩展属性
     */
    private List<ProductAttrDto> productAttrs;

    /**
     * 产品规格参数
     */
    private List<ProductParameterDto> productParameters;

    /**
     * 产品规格
     */
    private List<ProductFashionDto> productFashions;

    private ProductFashionDto defaultFashion;

    public ProductFashionDto getFashionById(String fashionId) {
        if(this.getProductFashions() != null || this.getProductFashions().size() > 0) {
            for(ProductFashionDto pf : this.productFashions) {
                if(fashionId.equals(pf.getId())) {
                    return pf;
                }
            }
        }
        return null;
    }

    public ProductFashionDto getDefaultFashion() {
        ProductFashionDto defaultFashion = null;
        if(this.productFashions != null && this.productFashions.size() > 0) {
            Collections.sort(this.productFashions, (o1, o2) -> {
                if(o1.getSortNum() == null) {
                    // 为空的都押后去
                    return 1;
                }
                if(o2.getSortNum() == null) {
                    return -1;
                }
                return o1.getSortNum().compareTo(o2.getSortNum());
            });
            defaultFashion = this.productFashions.get(0);
            // 如果有设置default为1的，则为默认的规格
            for(ProductFashionDto pf : this.productFashions) {
                if(pf.getDefault() != null && pf.getDefault()) {
                    defaultFashion = pf;
                }
            }
        }
        return defaultFashion;
    }

    public List<ProductFashionDto> getProductFashions() {
        return productFashions;
    }

    public void setProductFashions(List<ProductFashionDto> productFashions) {
        this.productFashions = productFashions;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public ProductCategoryDto getProductCategory() {
        return productCategory;
    }

    public void setProductCategory(ProductCategoryDto productCategory) {
        this.productCategory = productCategory;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public List<ProductStandardDto> getProductStandards() {
        return productStandards;
    }

    public void setProductStandards(List<ProductStandardDto> productStandards) {
        this.productStandards = productStandards;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(BigDecimal marketPrice) {
        this.marketPrice = marketPrice;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Integer getSaleCount() {
        return saleCount;
    }

    public void setSaleCount(Integer saleCount) {
        this.saleCount = saleCount;
    }

    public Integer getShowIndex() {
        return showIndex;
    }

    public void setShowIndex(Integer showIndex) {
        this.showIndex = showIndex;
    }

    public List<ProductAttrDto> getProductAttrs() {
        return productAttrs;
    }

    public void setProductAttrs(List<ProductAttrDto> productAttrs) {
        this.productAttrs = productAttrs;
    }

    public List<ProductParameterDto> getProductParameters() {
        return productParameters;
    }

    public void setProductParameters(List<ProductParameterDto> productParameters) {
        this.productParameters = productParameters;
    }

    public List<ProductDto> getParents() {
        return parents;
    }

    public void setParents(List<ProductDto> parents) {
        this.parents = parents;
    }

    /**
     * @deprecated 此方法已弃用于2018-02-12
     * <p>弃用理由：不再进行Product的children转换，需要查找子商品时</p>
     * <p>需使用ProductFashion的children来获取关联商品</p>
     * <p><b>ProductFashion唯一标识一个可售商品，关联关系通过ProductGroupFashion进行维护</b></p>
     * @return
     */
    public List<ProductDto> getChildren() {
        if(this.children != null) {
            return children;
        }
        children = new ArrayList<>();
        // 使用fashion来获取关联产品，但主要还是用Fashion进行关联的展示
        if(this.getProductFashions() != null) {
            for(ProductFashionDto pfd : this.getProductFashions()) {
                //children.add(this);
            }
        }
        return children;
    }

    public void setChildren(List<ProductDto> children) {
        this.children = children;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSaleUnit() {
        return saleUnit;
    }

    public void setSaleUnit(String saleUnit) {
        this.saleUnit = saleUnit;
    }

    public String getSaleStatus() {
        return saleStatus;
    }

    public void setSaleStatus(String saleStatus) {
        this.saleStatus = saleStatus;
    }

    public String getUpdownStatus() {
        return updownStatus;
    }

    public void setUpdownStatus(String updownStatus) {
        this.updownStatus = updownStatus;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getUpc() {
        return upc;
    }

    public void setUpc(String upc) {
        this.upc = upc;
    }

    public Boolean getRecommendFlag() {
        return recommendFlag;
    }

    public void setRecommendFlag(Boolean recommendFlag) {
        this.recommendFlag = recommendFlag;
    }

    public Boolean getSpecialFlag() {
        return specialFlag;
    }

    public void setSpecialFlag(Boolean specialFlag) {
        this.specialFlag = specialFlag;
    }

    public Boolean getHotsale() {
        return hotsale;
    }

    public void setHotsale(Boolean hotsale) {
        this.hotsale = hotsale;
    }

    public Boolean getNewProduct() {
        return newProduct;
    }

    public void setNewProduct(Boolean newProduct) {
        this.newProduct = newProduct;
    }

    public String getAfterSaleDetails() {
        return afterSaleDetails;
    }

    public void setAfterSaleDetails(String afterSaleDetails) {
        this.afterSaleDetails = afterSaleDetails;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ProductDto product = (ProductDto) o;

        return id != null ? id.equals(product.id) : product.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public void setDefaultFashion(ProductFashionDto defaultFashion) {
        this.defaultFashion = defaultFashion;
    }

    public List<GoodsDto> getGoodses() {
        return goodses;
    }

    public void setGoodses(List<GoodsDto> goodses) {
        this.goodses = goodses;
    }

    @Override
    public String toString() {
        return "ProductDto{" +
                "id='" + id + '\'' +
                ", productName='" + productName + '\'' +
                ", storeId='" + storeId + '\'' +
                ", title='" + title + '\'' +
                ", code='" + code + '\'' +
                ", type='" + type + '\'' +
                ", marketPrice=" + marketPrice +
                ", salePrice=" + salePrice +
                ", costPrice=" + costPrice +
                ", saleCount=" + saleCount +
                ", saleUnit='" + saleUnit + '\'' +
                ", saleStatus='" + saleStatus + '\'' +
                ", updownStatus='" + updownStatus + '\'' +
                ", auditStatus='" + auditStatus + '\'' +
                ", upc='" + upc + '\'' +
                ", recommendFlag=" + recommendFlag +
                ", specialFlag=" + specialFlag +
                ", hotsale=" + hotsale +
                ", newProduct=" + newProduct +
                ", afterSaleDetails='" + afterSaleDetails + '\'' +
                ", showIndex=" + showIndex +
                ", parents=" + parents +
                ", children=" + children +
                ", productStandards=" + productStandards +
                ", productCategory=" + productCategory +
                ", productAttrs=" + productAttrs +
                ", productParameters=" + productParameters +
                ", productFashions=" + productFashions +
                ", defaultFashion=" + defaultFashion +
                '}';
    }
}
