package activities.dto.goods;

import sinomall.global.dto.base.BaseDomainDto;
import utils.Lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 产品规格
 * Created by Roney on 2016/11/29.
 */
public class ProductFashionDto extends BaseDomainDto implements Serializable {

    private String id;

    private ProductDto product;

    private GoodsDto goods;

    /**
     * 规格标题（默认同Product）
     */
    private String fashionTitle;

    /**
     * 规格ID
     */
    private String productStandardId;

    /**
     * 库存数量
     */
    private Integer stockCount;

    /**
     * 是否在售
     *  */
    private Boolean onSale;

    /**
     * 规格名称，用于展示名称
     * */
    private String fieldName;

    /**
     * 规格代码
     */
    private String fieldCode;

    /**
     * 数据类型
     * 1为文字 2为图片
     * */
    private String fieldType;

    /**
     * 规格值
     */
    private String value;

    /**
     * 规格值名称
     */
    private String valueName;

    /**
     * 市场价
     * */

    private BigDecimal marketPrice;

    /**
     * 销售价
     * */

    private BigDecimal salePrice;

    /**
     * 成本价
     * */

    private BigDecimal costPrice;

    /** 销售统计 */
    private Integer saleCount;

    /**
     * 产品code
     * */
    private String productCode;

    /**
     * 库存不足预警最小值
     *  */
    private Integer lackRemind;

    /**
     * 规格介绍
     * */
    private String fashionPiction;

    /**
     * 图片 */
    private String fashionPic;


    /**
     * 是否默认
     *
     * 多种组合只能有一个默认
     *
     * 同一个goodsID
     *
     * */

    private Boolean isDefault;

    /**
     * 展示排序
     */
    private Integer sortNum;

    /**
     * 父级关联产品规格
     */
    private List<ProductFashionDto> parents;

    /**
     * 从属关联产品规格列表
     */
    private List<ProductFashionDto> children;

    private List<ProductFashionSpecificationDto> productFashionSpecifications;

    private List<ProductFashionPictureDto> productFashionPictures;

    private List<ProductParameterDto> productFashionParameters;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ProductFashionSpecificationDto> getProductFashionSpecifications() {
        return productFashionSpecifications;
    }

    public void setProductFashionSpecifications(List<ProductFashionSpecificationDto> productFashionSpecifications) {
        this.productFashionSpecifications = productFashionSpecifications;
    }

    public ProductDto getProduct() {
        return product;
    }

    public void setProduct(ProductDto product) {
        this.product = product;
    }

    public String getProductStandardId() {
        return productStandardId;
    }

    public void setProductStandardId(String productStandardId) {
        this.productStandardId = productStandardId;
    }

    public Integer getStockCount() {
        return stockCount;
    }

    public void setStockCount(Integer stockCount) {
        this.stockCount = stockCount;
    }

    public Boolean getOnSale() {
        return onSale;
    }

    public void setOnSale(Boolean onSale) {
        this.onSale = onSale;
    }

    public BigDecimal getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(BigDecimal marketPrice) {
        this.marketPrice = marketPrice;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Integer getSaleCount() {
        return saleCount;
    }

    public void setSaleCount(Integer saleCount) {
        this.saleCount = saleCount;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Integer getLackRemind() {
        return lackRemind;
    }

    public void setLackRemind(Integer lackRemind) {
        this.lackRemind = lackRemind;
    }

    public String getFashionPiction() {
        return fashionPiction;
    }

    public void setFashionPiction(String fashionPiction) {
        this.fashionPiction = fashionPiction;
    }

    /**
     * 获取Fashion的默认图片，如不设置，则获取所有图片中的默认图片
     * @return
     */
    public String getFashionPic() {
        if(Lang.isEmpty(fashionPic) && this.getProductFashionPictures() != null) {
            for(ProductFashionPictureDto p : this.getProductFashionPictures()) {
                if(p.getDefaultFlag()) {
                    fashionPic = p.getAppPicturePath();
                }
            }

            if(Lang.isEmpty(fashionPic) && this.getProductFashionPictures().size() > 0) {
                fashionPic = this.getProductFashionPictures().get(0).getAppPicturePath();
            }
        }
        return fashionPic;
    }

    public void setFashionPic(String fashionPic) {
        this.fashionPic = fashionPic;
    }

    public Boolean getDefault() {
        return isDefault;
    }

    public void setDefault(Boolean aDefault) {
        isDefault = aDefault;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldCode() {
        return fieldCode;
    }

    public void setFieldCode(String fieldCode) {
        this.fieldCode = fieldCode;
    }

    public String getFieldType() {
        return fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValueName() {
        return valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public Integer getSortNum() {
        return sortNum;
    }

    public void setSortNum(Integer sortNum) {
        this.sortNum = sortNum;
    }

    public List<ProductFashionPictureDto> getProductFashionPictures() {
        return productFashionPictures;
    }

    public void setProductFashionPictures(List<ProductFashionPictureDto> productFashionPictures) {
        this.productFashionPictures = productFashionPictures;
    }

    public List<ProductParameterDto> getProductFashionParameters() {
        return productFashionParameters;
    }

    public void setProductFashionParameters(List<ProductParameterDto> productFashionParameters) {
        this.productFashionParameters = productFashionParameters;
    }

    public List<ProductFashionDto> getParents() {
        return parents;
    }

    public void setParents(List<ProductFashionDto> parents) {
        this.parents = parents;
    }

    public List<ProductFashionDto> getChildren() {
        return children;
    }

    public void setChildren(List<ProductFashionDto> children) {
        this.children = children;
    }

    public String getFashionTitle() {
        return fashionTitle;
    }

    public void setFashionTitle(String fashionTitle) {
        this.fashionTitle = fashionTitle;
    }

    public GoodsDto getGoods() {
        return goods;
    }

    public void setGoods(GoodsDto goods) {
        this.goods = goods;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ProductFashionDto that = (ProductFashionDto) o;
        if(id == null && that.id ==null) {
            return  productCode != null ? productCode.equals(that.productCode) : that.productCode == null;
        } else {
            return id != null ? id.equals(that.id) : that.id == null;
        }
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

}