package activities.dto.goods;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;

/**
 * 产品规格定义，多个standard组成一个特定的规格，规格是最小粒度的可售产品
 * Created by Roney on 2016/11/29.
 */
public class ProductFashionSpecificationDto extends BaseDomainDto implements Serializable {

    private String id;
    //规格代码
    private String standardCode;
    //规格值
    private String value;

    private ProductFashionDto productFashion;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ProductFashionDto getProductFashion() {
        return productFashion;
    }

    public void setProductFashion(ProductFashionDto productFashion) {
        this.productFashion = productFashion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ProductFashionSpecificationDto that = (ProductFashionSpecificationDto) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}