package activities.dto.goods;

//import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;


/**
 * Created by Roney on 2016/11/7.
 *
 * 模型的数据类型表
 */
public class ProductModelAttrDto extends BaseDomainDto implements Serializable {

    public ProductModelAttrDto() {

    }

    public ProductModelAttrDto(String code, String name, String label, String widgetType, String htmlType, String defaultValue, String optionValue, String dataSource, Boolean requiredFlag, Boolean displayFlag, Boolean readonlyFlag, Boolean confirmDisplayFlag, Integer priority, Boolean validFlag, String tip, String errorTip, String constraintsScript, ProductModelDto productModel) {
        this.code = code;
        this.name = name;
        this.label = label;
        this.widgetType = widgetType;
        this.htmlType = htmlType;
        this.defaultValue = defaultValue;
        this.optionValue = optionValue;
        this.dataSource = dataSource;
        this.requiredFlag = requiredFlag;
        this.displayFlag = displayFlag;
        this.readonlyFlag = readonlyFlag;
        this.confirmDisplayFlag = confirmDisplayFlag;
        this.priority = priority;
        this.validFlag = validFlag;
        this.tip = tip;
        this.errorTip = errorTip;
        this.constraintsScript = constraintsScript;
        this.productModel = productModel;
    }

    private String id;

    /**
     * 代码，页面隐藏 name or id
     */

    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 显示中文标签
     */
    private String label;



    /**
     * 页面控件类型
     */
    private String widgetType;


    private String htmlType;
    public static final Map<String,String> htmlTypeMap = new LinkedHashMap<String, String>(){{
        put("input", "INPUT");
        put("select", "SELECT");
        put("checkbox", "CHECKBOX");
        put("radio","RADIO");
        put("raw", "RAW");
        put("ui-select", "UI-SELECT");
        put("sin-select", "UI-SINGLE-SELECT");
        put("label", "LABEL");
        put("other", "OTHER");
    }};

    /**
     * 默认取值
     */
    private String defaultValue;

    /**
     * 可选取值
     */
    private String optionValue;




    /**
     * 数据来源，通常是下拉控件
     */
    private String dataSource;



    /**
     * 是否必录
     */
    private Boolean requiredFlag;

    /**
     * 是否显示
     */
    private Boolean displayFlag;

    /**
     * 是否可写
     */
    private Boolean readonlyFlag;

    /**
     * 投保确认时是否显示
     */
    private Boolean confirmDisplayFlag;

    /**
     * 显示序号
     */
    private Integer priority;


    /**
     * 有效标志
     */
    private Boolean validFlag;

    public void setValidFlags(Map<String, String> validFlags) {
        this.validFlags = validFlags;
    }

    private Map<String, String> validFlags = new LinkedHashMap<String, String>() {
        {
            put("true", "有效");
            put("false", "无效");
        }
    };

    /**
     * 输入提示信息
     */
    private String tip;

    /**
     * 错误提示信息
     */
    private String errorTip;

    /**
     * 录入数据关联控制脚本
     */
    private String constraintsScript;


    private ProductModelDto productModel;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ProductModelAttrDto that = (ProductModelAttrDto) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getWidgetType() {
        return widgetType;
    }

    public void setWidgetType(String widgetType) {
        this.widgetType = widgetType;
    }

    public String getHtmlType() {
        return htmlType;
    }

    public void setHtmlType(String htmlType) {
        this.htmlType = htmlType;
    }

    public static Map<String, String> getHtmlTypeMap() {
        return htmlTypeMap;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getOptionValue() {
        return optionValue;
    }

    public void setOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }

    public String getDataSource() {
        return dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public Boolean getRequiredFlag() {
        return requiredFlag;
    }

    public void setRequiredFlag(Boolean requiredFlag) {
        this.requiredFlag = requiredFlag;
    }

    public Boolean getDisplayFlag() {
        return displayFlag;
    }

    public void setDisplayFlag(Boolean displayFlag) {
        this.displayFlag = displayFlag;
    }

    public Boolean getReadonlyFlag() {
        return readonlyFlag;
    }

    public void setReadonlyFlag(Boolean readonlyFlag) {
        this.readonlyFlag = readonlyFlag;
    }

    public Boolean getConfirmDisplayFlag() {
        return confirmDisplayFlag;
    }

    public void setConfirmDisplayFlag(Boolean confirmDisplayFlag) {
        this.confirmDisplayFlag = confirmDisplayFlag;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Boolean getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Boolean validFlag) {
        this.validFlag = validFlag;
    }

    public Map<String, String> getValidFlags() {
        return validFlags;
    }

    public String getTip() {
        return tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getErrorTip() {
        return errorTip;
    }

    public void setErrorTip(String errorTip) {
        this.errorTip = errorTip;
    }

    public String getConstraintsScript() {
        return constraintsScript;
    }

    public void setConstraintsScript(String constraintsScript) {
        this.constraintsScript = constraintsScript;
    }

    public ProductModelDto getProductModel() {
        return productModel;
    }

    public void setProductModel(ProductModelDto productModel) {
        this.productModel = productModel;
    }
}
