package activities.dto.goods;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.List;

/**
 * Created by Roney on 2016/9/29.
 *
 * 产品的模型
 */
public class ProductModelDto extends BaseDomainDto implements Serializable {

    private String id;

    /**
     * 模型名称
     *  */
    private String modelName;

    /**
     * 路径
     * */
    private String path;

    /**
     * 图片
     * */
    private String modelImg;

    /**
     * 是否默认
     *
     * */
    private Boolean isDefaultModel;




    private List<ProductCategoryDto> productCategorys;

    private List<ProductModelAttrDto> productModelAttrs;

    public List<ProductModelAttrDto> getProductModelAttrs() {
        return productModelAttrs;
    }

    public void setProductModelAttrs(List<ProductModelAttrDto> productModelAttrs) {
        this.productModelAttrs = productModelAttrs;
    }

    public List<ProductCategoryDto> getProductCategorys() {
        return productCategorys;
    }

    public void setProductCategorys(List<ProductCategoryDto> productCategorys) {
        this.productCategorys = productCategorys;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getModelImg() {
        return modelImg;
    }

    public void setModelImg(String modelImg) {
        this.modelImg = modelImg;
    }

    public Boolean getIsDefaultModel() {
        return isDefaultModel;
    }

    public void setIsDefaultModel(Boolean defaultModel) {
        isDefaultModel = defaultModel;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ProductModelDto that = (ProductModelDto) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}
