package activities.dto.goods;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018-01-08
 */
public class ProductParameterDto extends BaseDomainDto implements Serializable {
    /**
     * 数据类型{@value}: 字符值
     */
    public static final String DATA_TYPE_STRINGVAL = "1";
    /**
     * 数据类型{@value}: 图片（路径）
     */
    public static final String DATA_TYPE_PICPATH = "2";

    private String id;

    /**
     * 参数名称
     */
    private String name;

    /**
     * 参数代码（可选）
     */
    private String code;

    /**
     * 参数值
     */
    private String value;

    /**
     * 数据类型
     */
    private String dataType;

    /**
     * 排序
     *  */
    private Integer showIndex = 0;
    /**
     * 父参数，顶级时为空
     */
    private ProductParameterDto parent;

    /**
     * 子参数
     */
    private List<ProductParameterDto> child;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public Integer getShowIndex() {
        return showIndex;
    }

    public void setShowIndex(Integer showIndex) {
        this.showIndex = showIndex;
    }

    public ProductParameterDto getParent() {
        return parent;
    }

    public void setParent(ProductParameterDto parent) {
        this.parent = parent;
    }

    public List<ProductParameterDto> getChild() {
        return child;
    }

    public void setChild(List<ProductParameterDto> child) {
        this.child = child;
    }
}
