package activities.dto.goods;


import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.List;

/**
 * Created by Roney on 2016/9/27.
 * 规格
 */
public class ProductStandardDto extends BaseDomainDto implements Serializable {

    private String id;


    /**
     * 规格code
     */
    private String standardCode;
    /**
     * 规格名称
     */
    private String name;

    /**
     *
     * */
    private String field;

    /**
     * 数据类型
     * 1为文字 2为图片
     * */
    private Integer dataType;

    /**
     * 是否开始
     *  */
    private Boolean isStart;

    /**
     * 是否使用
     * */
    private Boolean isUsing;

    /**
     * 颜色
     * 忽略此字段
     *  */
    private String color;

    /**
     * 排序
     *  */
    private Integer showIndex;

    /**
     * 描述
     *  */
    private String description;

    /**
     * 是否选中
     */
    private Boolean selected;

    private List<ProductStandardValueDto> productStandardValues;

    private ProductDto product;

    public ProductDto getProduct() {
        return product;
    }

    public void setProduct(ProductDto product) {
        this.product = product;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Integer getShowIndex() {
        return showIndex;
    }

    public void setShowIndex(Integer showIndex) {
        this.showIndex = showIndex;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Integer getDataType() {
        return dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public Boolean getStart() {
        return isStart;
    }

    public void setStart(Boolean start) {
        isStart = start;
    }

    public Boolean getUsing() {
        return isUsing;
    }

    public void setUsing(Boolean using) {
        isUsing = using;
    }

    public List<ProductStandardValueDto> getProductStandardValues() {
        return productStandardValues;
    }

    public void setProductStandardValues(List<ProductStandardValueDto> productStandardValues) {
        this.productStandardValues = productStandardValues;
    }

    public Boolean getSelected() {
        return selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ProductStandardDto that = (ProductStandardDto) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}