package activities.dto.groupbuying.response;

import activities.definition.ActivityDefinitionType;
import activities.definition.GbGroupInfoStatus;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GbGroupInfoRespDto  implements Serializable {
    /**
     * 拼团定义id
     */
    private String gbActivityInfoId;
    /**
     * 团状态
     */
    private GbGroupInfoStatus gbGroupInfoStatus;
    /**
     * 团定义状态
     */
    private ActivityDefinitionType activityDefinitionType;
    /**
     * 开团时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date groupStartTime;
    /**
     * 截止时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date groupEndTime;
    /**
     * 总人数
     */
    private Integer totalNumber;
    /**
     * 已参团人数
     */
    private Integer numberParticipation;

    public String getGbActivityInfoId() {
        return gbActivityInfoId;
    }

    public void setGbActivityInfoId(String gbActivityInfoId) {
        this.gbActivityInfoId = gbActivityInfoId;
    }

    public GbGroupInfoStatus getGbGroupInfoStatus() {
        return gbGroupInfoStatus;
    }

    public void setGbGroupInfoStatus(GbGroupInfoStatus gbGroupInfoStatus) {
        this.gbGroupInfoStatus = gbGroupInfoStatus;
    }

    public ActivityDefinitionType getActivityDefinitionType() {
        return activityDefinitionType;
    }

    public void setActivityDefinitionType(ActivityDefinitionType activityDefinitionType) {
        this.activityDefinitionType = activityDefinitionType;
    }

    public Date getGroupStartTime() {
        return groupStartTime;
    }

    public void setGroupStartTime(Date groupStartTime) {
        this.groupStartTime = groupStartTime;
    }

    public Date getGroupEndTime() {
        return groupEndTime;
    }

    public void setGroupEndTime(Date groupEndTime) {
        this.groupEndTime = groupEndTime;
    }

    public Integer getTotalNumber() {
        return totalNumber;
    }

    public void setTotalNumber(Integer totalNumber) {
        this.totalNumber = totalNumber;
    }

    public Integer getNumberParticipation() {
        return numberParticipation;
    }

    public void setNumberParticipation(Integer numberParticipation) {
        this.numberParticipation = numberParticipation;
    }
}
