package activities.dto.modeldto;

import com.alibaba.fastjson.annotation.JSONField;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by xiaoqian on 2016/9/29.
 */
public class ActivityDefinitionDto extends BaseDomainDto implements Serializable {
    protected String id;

    private String organizationCode;             //渠道代码
    private String name;                //活动名称
    private String describe;            //活动描述
    private String category;            //活动类别
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date beginTime;             //开始时间
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date endTime;               //结束时间
    private Boolean isOnline;    //是否上线

    private String activityCode;            //活动代码

    public Boolean getOnline() {
        return isOnline;
    }

    public void setOnline(Boolean online) {
        isOnline = online;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    private List<ActivityThemeDto> activityThemes;
    private List<ActivityGoodsDto> activityGoodses;

    public List<ActivityGoodsDto> getActivityGoodses() {
        return activityGoodses;
    }

    public void setActivityGoodses(List<ActivityGoodsDto> activityGoodses) {
        this.activityGoodses = activityGoodses;
    }

    public List<ActivityThemeDto> getActivityThemes() {
        return activityThemes;
    }

    public void setActivityThemes(List<ActivityThemeDto> activityThemes) {
        this.activityThemes = activityThemes;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescribe() {
        return describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Boolean getIsOnline() {
        return isOnline;
    }

    public void setIsOnline(Boolean isOnline) {
        this.isOnline = isOnline;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ActivityDefinitionDto that = (ActivityDefinitionDto) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ActivityDefinitionDto{" +
                "id='" + id + '\'' +
                ", organizationCode='" + organizationCode + '\'' +
                ", name='" + name + '\'' +
                ", describe='" + describe + '\'' +
                ", category='" + category + '\'' +
                ", beginTime=" + beginTime +
                ", endTime=" + endTime +
                ", isOnline=" + isOnline +
                ", activityCode='" + activityCode + '\'' +
                ", activityThemes=" + activityThemes +
                ", activityGoodses=" + activityGoodses +
                '}';
    }
}
