package activities.dto.modeldto;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoqian on 2016/9/29.
 */
public class ActivityGoodsDto extends BaseDomainDto implements Serializable {
    public static String ACTIVITY_PRICE_TYPE_WITHRATE = "0";   //按原价格走费率展示
    public static String ACTIVITY_PRICE_TYPE_WITHOUTRATE = "1";  //不走费率
    public static String ACTIVITY_PRICE_TYPE_ACPRICE = "2";   //按固定活动价

    public static Map<String, Object> priceTypes = new HashMap<>();

    static {
        priceTypes.put(ACTIVITY_PRICE_TYPE_WITHRATE, "活动价走费率");
        priceTypes.put(ACTIVITY_PRICE_TYPE_WITHOUTRATE, "活动价不走费率");
        priceTypes.put(ACTIVITY_PRICE_TYPE_ACPRICE, "活动价按配置固定价");
    }

    protected String id;

    private String goodsId;
    //商品id
    private ActivityDefinitionDto activityDefinition;                  //关联活动定义表
    private BigDecimal goodsPrice;                                      //商品活动价格
    private Integer stockNum;                                        //库存数量
    private Integer soldNum;                                         //已售销量
    private Integer banNum;                                          //个人限购数量
    private Boolean isOnline;                                //是否上线
    private String giftClass;                                       //礼包类型
    private String type;                                             //活动价类型

    /**
     * 分组概念引入
     */

    /**
     * 商品排序
     * 显示同一组的商品排序
     */
    private Integer groupIndex;

//     @ManyToOne(fetch = FetchType.EAGER)
//    @JoinColumn(name = "activity_group_id", foreignKey = @ForeignKey(name = "fk_activity_group_id"))
//    ActivityGroupGoods activityGroupGoods;

    /**
     * 商品排序
     * 显示同一组的商品排序
     */
    private Integer showIndex;

    ActivityThemeDto activityTheme;

    public ActivityThemeDto getActivityTheme() {
        return activityTheme;
    }

    public void setActivityTheme(ActivityThemeDto activityTheme) {
        this.activityTheme = activityTheme;
    }


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGiftClass() {
        return giftClass;
    }

    public void setGiftClass(String giftClass) {
        this.giftClass = giftClass;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public ActivityDefinitionDto getActivityDefinition() {
        return activityDefinition;
    }

    public void setActivityDefinition(ActivityDefinitionDto activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public BigDecimal getGoodsPrice() {
        return goodsPrice;
    }

    public void setGoodsPrice(BigDecimal goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public Integer getStockNum() {
        return stockNum;
    }

    public void setStockNum(Integer stockNum) {
        this.stockNum = stockNum;
    }

    public Integer getSoldNum() {
        return soldNum;
    }

    public void setSoldNum(Integer soldNum) {
        this.soldNum = soldNum;
    }

    public Integer getBanNum() {
        return banNum;
    }

    public void setBanNum(Integer banNum) {
        this.banNum = banNum;
    }

    public Boolean getIsOnline() {
        return isOnline;
    }

    public void setIsOnline(Boolean isOnline) {
        this.isOnline = isOnline;
    }

    public Boolean getOnline() {
        return isOnline;
    }

    public void setOnline(Boolean online) {
        isOnline = online;
    }

//    public ActivityGroupGoods getActivityGroupGoods() {
//        return activityGroupGoods;
//    }
//
//    public void setActivityGroupGoods(ActivityGroupGoods activityGroupGoods) {
//        this.activityGroupGoods = activityGroupGoods;
//    }

    public Integer getGroupIndex() {
        return groupIndex;
    }

    public void setGroupIndex(Integer groupIndex) {
        this.groupIndex = groupIndex;
    }

    public Integer getShowIndex() {
        return showIndex;
    }

    public void setShowIndex(Integer showIndex) {
        this.showIndex = showIndex;
    }


}
