package activities.dto.modeldto.groupbuying;

import activities.dto.modeldto.ActivityDefinitionDto;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.List;

public class GbActivityInfoDto extends BaseDomainDto implements Serializable {

    protected String id;
    /**
     * 活动定义表Id
     */
    private ActivityDefinitionDto activityDefinition;
    /**
     * 几人团
     */
    private Integer numberNeed;
    /**
     * 可开团数量
     */
    private Integer numberGb;
    /**
     * 备注
     */
    private String memo;
    private List<GbGoodsDto> gbGoods;
    List<GbGroupInfoDto> gbGroupInfos;
    /**
     * 同步已过期且已确认预占库存的活动
     * */
    private String expiredSynchronize;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbActivityInfoDto that = (GbActivityInfoDto) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbActivityInfoDto{" +
                "id='" + id + '\'' +
                ", activityDefinition=" + activityDefinition +
                ", numberNeed=" + numberNeed +
                ", numberGb=" + numberGb +
                ", memo='" + memo + '\'' +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ActivityDefinitionDto getActivityDefinition() {
        return activityDefinition;
    }

    public void setActivityDefinition(ActivityDefinitionDto activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public Integer getNumberNeed() {
        return numberNeed;
    }

    public void setNumberNeed(Integer numberNeed) {
        this.numberNeed = numberNeed;
    }

    public Integer getNumberGb() {
        return numberGb;
    }

    public void setNumberGb(Integer numberGb) {
        this.numberGb = numberGb;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<GbGoodsDto> getGbGoods() {
        return gbGoods;
    }

    public void setGbGoods(List<GbGoodsDto> gbGoods) {
        this.gbGoods = gbGoods;
    }

    public List<GbGroupInfoDto> getGbGroupInfos() {
        return gbGroupInfos;
    }

    public void setGbGroupInfos(List<GbGroupInfoDto> gbGroupInfos) {
        this.gbGroupInfos = gbGroupInfos;
    }

    public String getExpiredSynchronize() {
        return expiredSynchronize;
    }

    public void setExpiredSynchronize(String expiredSynchronize) {
        this.expiredSynchronize = expiredSynchronize;
    }
}
