package activities.dto.modeldto.groupbuying;

import activities.dto.modeldto.ActivityGoodsDto;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;

public class GbGoodsDto extends BaseDomainDto implements Serializable {
    protected String id;
    /**
     * 活动商品表 Id
     */
    private ActivityGoodsDto activityGoods;

    private GbActivityInfoDto gbActivityInfo;
    /**
     * 拼团价格
     */
    private BigDecimal gbPrice;
    /**
     * 价格类型
     */
    private String priceType;
    /**
     * 是否显示
     */
    private Boolean isDisplay;
    /**
     * 排序
     */
    private Integer sortOrder;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbGoodsDto gbGoods = (GbGoodsDto) o;

        return id != null ? id.equals(gbGoods.id) : gbGoods.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbGoodsDto{" +
                "id='" + id + '\'' +
                ", gbPrice=" + gbPrice +
                ", priceType='" + priceType + '\'' +
                ", isDisplay=" + isDisplay +
                ", sortOrder=" + sortOrder +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ActivityGoodsDto getActivityGoods() {
        return activityGoods;
    }

    public void setActivityGoods(ActivityGoodsDto activityGoods) {
        this.activityGoods = activityGoods;
    }

    public GbActivityInfoDto getGbActivityInfo() {
        return gbActivityInfo;
    }

    public void setGbActivityInfo(GbActivityInfoDto gbActivityInfo) {
        this.gbActivityInfo = gbActivityInfo;
    }

    public BigDecimal getGbPrice() {
        return gbPrice;
    }

    public void setGbPrice(BigDecimal gbPrice) {
        this.gbPrice = gbPrice;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public Boolean getDisplay() {
        return isDisplay;
    }

    public void setDisplay(Boolean display) {
        isDisplay = display;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }
}
