package activities.dto.modeldto.groupbuying;

import com.alibaba.fastjson.annotation.JSONField;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.Date;

public class GbGroupInfoDto extends BaseDomainDto implements Serializable {
    protected String id;
    /**
     * 拼团信息表Id
     */
    private GbActivityInfoDto gbActivityInfo;
    /**
     * 开团时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date groupStartTime;
    /**
     * 截止时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date groupEndTime;
    /**
     * 开团人
     */
    private String memberId;
    /**
     * 已参团人数
     */
    private Integer numberParticipation;
    /**
     * 团状态 0 未成团 1 已成团
     *  {@link GbGroupInfoStatus}
     */
    private String status;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbGroupInfoDto that = (GbGroupInfoDto) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbGroupInfoDto{" +
                "id='" + id + '\'' +
                ", groupStartTime=" + groupStartTime +
                ", groupEndTime=" + groupEndTime +
                ", memberId=" + memberId +
                ", numberParticipation=" + numberParticipation +
                ", status='" + status + '\'' +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GbActivityInfoDto getGbActivityInfo() {
        return gbActivityInfo;
    }

    public void setGbActivityInfo(GbActivityInfoDto gbActivityInfo) {
        this.gbActivityInfo = gbActivityInfo;
    }

    public Date getGroupStartTime() {
        return groupStartTime;
    }

    public void setGroupStartTime(Date groupStartTime) {
        this.groupStartTime = groupStartTime;
    }

    public Date getGroupEndTime() {
        return groupEndTime;
    }

    public void setGroupEndTime(Date groupEndTime) {
        this.groupEndTime = groupEndTime;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Integer getNumberParticipation() {
        return numberParticipation;
    }

    public void setNumberParticipation(Integer numberParticipation) {
        this.numberParticipation = numberParticipation;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
