package activities.dto.modeldto.groupbuying;

import com.alibaba.fastjson.annotation.JSONField;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.Date;

public class GbGroupJoinDto extends BaseDomainDto implements Serializable {
    protected String id;
    /**
     * 团号
     */
    private GbGroupInfoDto gbGroupInfo;
    /**
     * 用户
     */
    private String memberId;
    /**
     * 是否团长
     */
    private Boolean isLeader;
    /**
     * 参团时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateJoin;
    /**
     * 是否参团成功
     */
    private Boolean isDelivery;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbGroupJoinDto that = (GbGroupJoinDto) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbGroupJoinDto{" +
                "id='" + id + '\'' +
                ", memberId='" + memberId + '\'' +
                ", isLeader=" + isLeader +
                ", dateJoin=" + dateJoin +
                ", isDelivery=" + isDelivery +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GbGroupInfoDto getGbGroupInfo() {
        return gbGroupInfo;
    }

    public void setGbGroupInfo(GbGroupInfoDto gbGroupInfo) {
        this.gbGroupInfo = gbGroupInfo;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Boolean getIsLeader() {
        return isLeader;
    }

    public void setIsLeader(Boolean leader) {
        isLeader = leader;
    }

    public Date getDateJoin() {
        return dateJoin;
    }

    public void setDateJoin(Date dateJoin) {
        this.dateJoin = dateJoin;
    }

    public Boolean getDelivery() {
        return isDelivery;
    }

    public void setDelivery(Boolean delivery) {
        isDelivery = delivery;
    }


}
