package activities.dto.modeldto.groupbuying;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;

public class GbOrderInfoDto extends BaseDomainDto implements Serializable {
    protected String id;
    /**
     * 拼团活动定义id
     */
    private GbActivityInfoDto gbActivityInfo;
    /**
     * 参团记录ID
     */
    private GbGroupJoinDto gbGroupJoin;
    /**
     * 购买方式
     */
    private String typeBuy;
    /**
     * 下单来源渠道
     */
    private String channel;
    /**
     * 订单号
     */
    private String orderNo;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbOrderInfoDto that = (GbOrderInfoDto) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbOrderInfoDto{" +
                "id='" + id + '\'' +
                ", type_buy='" + typeBuy + '\'' +
                ", typeBuy='" + channel + '\'' +
                ", orderNo='" + orderNo + '\'' +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GbActivityInfoDto getGbActivityInfo() {
        return gbActivityInfo;
    }

    public void setGbActivityInfo(GbActivityInfoDto gbActivityInfo) {
        this.gbActivityInfo = gbActivityInfo;
    }

    public GbGroupJoinDto getGbGroupJoin() {
        return gbGroupJoin;
    }

    public void setGbGroupJoin(GbGroupJoinDto gbGroupJoin) {
        this.gbGroupJoin = gbGroupJoin;
    }

    public String getTypeBuy() {
        return typeBuy;
    }

    public void setTypeBuy(String typeBuy) {
        this.typeBuy = typeBuy;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }
}
