/*
 * Decompiled with CFR 0.152.
 */
package activities.dto.goods;

import activities.dto.goods.GoodsDto;
import activities.dto.goods.ProductAttrDto;
import activities.dto.goods.ProductCategoryDto;
import activities.dto.goods.ProductFashionDto;
import activities.dto.goods.ProductParameterDto;
import activities.dto.goods.ProductStandardDto;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sinomall.global.dto.base.BaseDomainDto;

public class ProductDto
extends BaseDomainDto
implements Serializable {
    public static final String PRODUCT_TYPE_MERCHANDISE = "1";
    public static final String PRODUCT_TYPE_FITTING = "2";
    public static final String PRODUCT_TYPE_GIFT = "3";
    private String id;
    private String productName;
    private String storeId;
    private String title;
    private String code;
    private String type;
    private BigDecimal marketPrice;
    private BigDecimal salePrice;
    private BigDecimal costPrice;
    private Integer saleCount = 0;
    private String saleUnit;
    private String saleStatus;
    private String updownStatus;
    private String auditStatus;
    private String upc;
    private Boolean recommendFlag = false;
    private Boolean specialFlag = false;
    private Boolean hotsale = false;
    private Boolean newProduct = false;
    private String afterSaleDetails;
    private Integer showIndex;
    private List<ProductDto> parents;
    private List<ProductDto> children;
    private List<ProductStandardDto> productStandards;
    private ProductCategoryDto productCategory;
    private List<GoodsDto> goodses;
    private List<ProductAttrDto> productAttrs;
    private List<ProductParameterDto> productParameters;
    private List<ProductFashionDto> productFashions;
    private ProductFashionDto defaultFashion;

    public ProductFashionDto getFashionById(String fashionId) {
        if (this.getProductFashions() != null || this.getProductFashions().size() > 0) {
            for (ProductFashionDto pf : this.productFashions) {
                if (!fashionId.equals(pf.getId())) continue;
                return pf;
            }
        }
        return null;
    }

    public ProductFashionDto getDefaultFashion() {
        ProductFashionDto defaultFashion = null;
        if (this.productFashions != null && this.productFashions.size() > 0) {
            Collections.sort(this.productFashions, (o1, o2) -> {
                if (o1.getSortNum() == null) {
                    return 1;
                }
                if (o2.getSortNum() == null) {
                    return -1;
                }
                return o1.getSortNum().compareTo(o2.getSortNum());
            });
            defaultFashion = this.productFashions.get(0);
            for (ProductFashionDto pf : this.productFashions) {
                if (pf.getDefault() == null || !pf.getDefault().booleanValue()) continue;
                defaultFashion = pf;
            }
        }
        return defaultFashion;
    }

    public List<ProductFashionDto> getProductFashions() {
        return this.productFashions;
    }

    public void setProductFashions(List<ProductFashionDto> productFashions) {
        this.productFashions = productFashions;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public ProductCategoryDto getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(ProductCategoryDto productCategory) {
        this.productCategory = productCategory;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public List<ProductStandardDto> getProductStandards() {
        return this.productStandards;
    }

    public void setProductStandards(List<ProductStandardDto> productStandards) {
        this.productStandards = productStandards;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getMarketPrice() {
        return this.marketPrice;
    }

    public void setMarketPrice(BigDecimal marketPrice) {
        this.marketPrice = marketPrice;
    }

    public BigDecimal getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getCostPrice() {
        return this.costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Integer getSaleCount() {
        return this.saleCount;
    }

    public void setSaleCount(Integer saleCount) {
        this.saleCount = saleCount;
    }

    public Integer getShowIndex() {
        return this.showIndex;
    }

    public void setShowIndex(Integer showIndex) {
        this.showIndex = showIndex;
    }

    public List<ProductAttrDto> getProductAttrs() {
        return this.productAttrs;
    }

    public void setProductAttrs(List<ProductAttrDto> productAttrs) {
        this.productAttrs = productAttrs;
    }

    public List<ProductParameterDto> getProductParameters() {
        return this.productParameters;
    }

    public void setProductParameters(List<ProductParameterDto> productParameters) {
        this.productParameters = productParameters;
    }

    public List<ProductDto> getParents() {
        return this.parents;
    }

    public void setParents(List<ProductDto> parents) {
        this.parents = parents;
    }

    public List<ProductDto> getChildren() {
        if (this.children != null) {
            return this.children;
        }
        this.children = new ArrayList<ProductDto>();
        if (this.getProductFashions() != null) {
            for (ProductFashionDto productFashionDto : this.getProductFashions()) {
            }
        }
        return this.children;
    }

    public void setChildren(List<ProductDto> children) {
        this.children = children;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSaleUnit() {
        return this.saleUnit;
    }

    public void setSaleUnit(String saleUnit) {
        this.saleUnit = saleUnit;
    }

    public String getSaleStatus() {
        return this.saleStatus;
    }

    public void setSaleStatus(String saleStatus) {
        this.saleStatus = saleStatus;
    }

    public String getUpdownStatus() {
        return this.updownStatus;
    }

    public void setUpdownStatus(String updownStatus) {
        this.updownStatus = updownStatus;
    }

    public String getAuditStatus() {
        return this.auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getUpc() {
        return this.upc;
    }

    public void setUpc(String upc) {
        this.upc = upc;
    }

    public Boolean getRecommendFlag() {
        return this.recommendFlag;
    }

    public void setRecommendFlag(Boolean recommendFlag) {
        this.recommendFlag = recommendFlag;
    }

    public Boolean getSpecialFlag() {
        return this.specialFlag;
    }

    public void setSpecialFlag(Boolean specialFlag) {
        this.specialFlag = specialFlag;
    }

    public Boolean getHotsale() {
        return this.hotsale;
    }

    public void setHotsale(Boolean hotsale) {
        this.hotsale = hotsale;
    }

    public Boolean getNewProduct() {
        return this.newProduct;
    }

    public void setNewProduct(Boolean newProduct) {
        this.newProduct = newProduct;
    }

    public String getAfterSaleDetails() {
        return this.afterSaleDetails;
    }

    public void setAfterSaleDetails(String afterSaleDetails) {
        this.afterSaleDetails = afterSaleDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductDto product = (ProductDto)o;
        return this.id != null ? this.id.equals(product.id) : product.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public void setDefaultFashion(ProductFashionDto defaultFashion) {
        this.defaultFashion = defaultFashion;
    }

    public List<GoodsDto> getGoodses() {
        return this.goodses;
    }

    public void setGoodses(List<GoodsDto> goodses) {
        this.goodses = goodses;
    }

    public String toString() {
        return "ProductDto{id='" + this.id + '\'' + ", productName='" + this.productName + '\'' + ", storeId='" + this.storeId + '\'' + ", title='" + this.title + '\'' + ", code='" + this.code + '\'' + ", type='" + this.type + '\'' + ", marketPrice=" + this.marketPrice + ", salePrice=" + this.salePrice + ", costPrice=" + this.costPrice + ", saleCount=" + this.saleCount + ", saleUnit='" + this.saleUnit + '\'' + ", saleStatus='" + this.saleStatus + '\'' + ", updownStatus='" + this.updownStatus + '\'' + ", auditStatus='" + this.auditStatus + '\'' + ", upc='" + this.upc + '\'' + ", recommendFlag=" + this.recommendFlag + ", specialFlag=" + this.specialFlag + ", hotsale=" + this.hotsale + ", newProduct=" + this.newProduct + ", afterSaleDetails='" + this.afterSaleDetails + '\'' + ", showIndex=" + this.showIndex + ", parents=" + this.parents + ", children=" + this.children + ", productStandards=" + this.productStandards + ", productCategory=" + this.productCategory + ", productAttrs=" + this.productAttrs + ", productParameters=" + this.productParameters + ", productFashions=" + this.productFashions + ", defaultFashion=" + this.defaultFashion + '}';
    }
}

