package activities.model;

import activities.model.base.BaseDomain;
import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by xiaoqian on 2016/9/29.
 */
@Entity
//@Table(name = "activity_definition")
@Cacheable(true)
public class ActivityDefinition extends BaseDomain implements Serializable {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;

    private String organizationCode;             //渠道代码
    private String name;                //活动名称
    private String describe;            //活动描述
    private String category;            //活动类别
    @Column(name = "begin_time")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date beginTime;             //开始时间
    @Column(name = "end_time")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date endTime;               //结束时间
    @Column(name = "is_online")
    private Boolean isOnline = true;    //是否上线

    private String activityCode;            //活动代码

    public Boolean getOnline() {
        return isOnline;
    }

    public void setOnline(Boolean online) {
        isOnline = online;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "activityDefinition")
    private List<ActivityTheme> activityThemes;
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "activityDefinition")
    private List<ActivityGoods> activityGoodses;

    public List<ActivityGoods> getActivityGoodses() {
        return activityGoodses;
    }

    public void setActivityGoodses(List<ActivityGoods> activityGoodses) {
        this.activityGoodses = activityGoodses;
    }

    public List<ActivityTheme> getActivityThemes() {
        return activityThemes;
    }

    public void setActivityThemes(List<ActivityTheme> activityThemes) {
        this.activityThemes = activityThemes;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescribe() {
        return describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Boolean getIsOnline() {
        return isOnline;
    }

    public void setIsOnline(Boolean isOnline) {
        this.isOnline = isOnline;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ActivityDefinition that = (ActivityDefinition) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ActivityDefinition{" +
                "id='" + id + '\'' +
                ", organizationCode='" + organizationCode + '\'' +
                ", name='" + name + '\'' +
                ", describe='" + describe + '\'' +
                ", category='" + category + '\'' +
                ", beginTime=" + beginTime +
                ", endTime=" + endTime +
                ", isOnline=" + isOnline +
                ", activityCode='" + activityCode + '\'' +
                ", activityThemes=" + activityThemes +
                ", activityGoodses=" + activityGoodses +
                '}';
    }
}
