package activities.model;

import activities.model.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoqian on 2016/9/29.
 */
@Entity
@Table(indexes = @Index(name = "idx_activity_definition_id", columnList = "activity_definition_id"))
@Cacheable(true)
public class ActivityGoods extends BaseDomain implements Serializable {
    public static String ACTIVITY_PRICE_TYPE_WITHRATE = "0";   //按原价格走费率展示
    public static String ACTIVITY_PRICE_TYPE_WITHOUTRATE = "1";  //不走费率
    public static String ACTIVITY_PRICE_TYPE_ACPRICE = "2";   //按固定活动价

    public static Map<String, Object> priceTypes = new HashMap<>();

    static {
        priceTypes.put(ACTIVITY_PRICE_TYPE_WITHRATE, "活动价走费率");
        priceTypes.put(ACTIVITY_PRICE_TYPE_WITHOUTRATE, "活动价不走费率");
        priceTypes.put(ACTIVITY_PRICE_TYPE_ACPRICE, "活动价按配置固定价");
    }

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;

    private String goodsId;
    //商品id
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "activity_definition_id", foreignKey = @ForeignKey(name = "fk_activity_definition"))
    private ActivityDefinition activityDefinition;                  //关联活动定义表
    @Column(name = "goods_price")
    private BigDecimal goodsPrice;                                      //商品活动价格
    @Column(name = "stock_num")
    private Integer stockNum;                                        //库存数量
    @Column(name = "sold_num")
    private Integer soldNum;                                         //已售销量
    @Column(name = "ban_num")
    private Integer banNum;                                          //个人限购数量
    @Column(name = "is_online")
    private Boolean isOnline = true;                                //是否上线
    @Column(name = "gift_class")
    private String giftClass;                                       //礼包类型
    private String type;                                             //活动价类型

    /**
     * 分组概念引入
     */

    /**
     * 商品排序
     * 显示同一组的商品排序
     */
    private Integer groupIndex;

//     @ManyToOne(fetch = FetchType.EAGER)
//    @JoinColumn(name = "activity_group_id", foreignKey = @ForeignKey(name = "fk_activity_group_id"))
//    ActivityGroupGoods activityGroupGoods;

    /**
     * 商品排序
     * 显示同一组的商品排序
     */
    private Integer showIndex;

    @ManyToOne
    @JoinColumn(name = "activity_theme_id", foreignKey = @ForeignKey(name = "fk_activity_theme_id"))
    ActivityTheme activityTheme;

    public ActivityTheme getActivityTheme() {
        return activityTheme;
    }

    public void setActivityTheme(ActivityTheme activityTheme) {
        this.activityTheme = activityTheme;
    }


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGiftClass() {
        return giftClass;
    }

    public void setGiftClass(String giftClass) {
        this.giftClass = giftClass;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public ActivityDefinition getActivityDefinition() {
        return activityDefinition;
    }

    public void setActivityDefinition(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public BigDecimal getGoodsPrice() {
        return goodsPrice;
    }

    public void setGoodsPrice(BigDecimal goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public Integer getStockNum() {
        return stockNum;
    }

    public void setStockNum(Integer stockNum) {
        this.stockNum = stockNum;
    }

    public Integer getSoldNum() {
        return soldNum;
    }

    public void setSoldNum(Integer soldNum) {
        this.soldNum = soldNum;
    }

    public Integer getBanNum() {
        return banNum;
    }

    public void setBanNum(Integer banNum) {
        this.banNum = banNum;
    }

    public Boolean getIsOnline() {
        return isOnline;
    }

    public void setIsOnline(Boolean isOnline) {
        this.isOnline = isOnline;
    }

    public Boolean getOnline() {
        return isOnline;
    }

    public void setOnline(Boolean online) {
        isOnline = online;
    }

//    public ActivityGroupGoods getActivityGroupGoods() {
//        return activityGroupGoods;
//    }
//
//    public void setActivityGroupGoods(ActivityGroupGoods activityGroupGoods) {
//        this.activityGroupGoods = activityGroupGoods;
//    }

    public Integer getGroupIndex() {
        return groupIndex;
    }

    public void setGroupIndex(Integer groupIndex) {
        this.groupIndex = groupIndex;
    }

    public Integer getShowIndex() {
        return showIndex;
    }

    public void setShowIndex(Integer showIndex) {
        this.showIndex = showIndex;
    }
}
