package activities.model;


import activities.model.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.List;

/**
 * Created by oracle on 2017-07-04.
 */

/**
 * 活动主题表
 *
 * @Id
 */
@Entity
public class ActivityTheme extends BaseDomain {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;
    //主题名
    private String name;
    //图片路径
    private String imgPath;
    //图片二进制存储（针对小图标）
    private byte[] img;
    //主题描述
    private String description;

    /**
     * 排序
     */
    @Column(name = "show_index", nullable = false)
    private Integer showIndex;

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "activityTheme")
    @OrderBy("groupIndex asc,showIndex asc ")
    private List<ActivityGoods> activityGoodses;
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "activity_Definition_id", foreignKey = @ForeignKey(name = "fk_m_activity_Definition_m_id"))
    private ActivityDefinition activityDefinition;

//    @OneToMany(fetch = FetchType.LAZY, mappedBy = "activityTheme")
//    @OrderBy("showIndex asc ")
//    private List<ActivityGroupGoods> activityGroupGoodses;

    public ActivityDefinition getActivityDefinition() {
        return activityDefinition;
    }

    public void setActivityDefinition(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public List<ActivityGoods> getActivityGoodses() {
        return activityGoodses;
    }

    public void setActivityGoodses(List<ActivityGoods> activityGoodses) {
        this.activityGoodses = activityGoodses;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImgPath() {
        return imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    public byte[] getImg() {
        return img;
    }

    public void setImg(byte[] img) {
        this.img = img;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }


    public Integer getShowIndex() {
        return showIndex;
    }

    public void setShowIndex(Integer showIndex) {
        this.showIndex = showIndex;
    }

//    public List<ActivityGroupGoods> getActivityGroupGoodses() {
//        return activityGroupGoodses;
//    }
//
//    public void setActivityGroupGoodses(List<ActivityGroupGoods> activityGroupGoodses) {
//        this.activityGroupGoodses = activityGroupGoodses;
//    }


}
