package activities.model.groupbuying;

import activities.model.ActivityDefinition;
import activities.model.base.BaseDomain;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.List;

@Data
@Entity
@Table(indexes = @Index(name = "idx_gb_ac_definition_id", columnList = "activity_definition_id"))
public class GbActivityInfo extends BaseDomain {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;
    /**
     * 活动定义表Id
     */
    @JoinColumn(name = "activity_definition_id", foreignKey = @ForeignKey(name = "fk_gb_activity_definition"))
    @OneToOne
    private ActivityDefinition activityDefinition;
    /**
     * 几人团
     */
    private Integer numberNeed;
    /**
     * 可开团数量
     */
    private Integer numberGb;
    /**
     * 备注
     */
    private String memo;
    @OneToMany(mappedBy = "gbActivityInfo", fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    private List<GbGoods> gbGoods;
    @OneToMany(mappedBy = "gbActivityInfo", fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    List<GbGroupInfo> gbGroupInfos;
    /**
     * 同步已过期且已确认预占库存的活动
     * */
    private String expiredSynchronize;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbActivityInfo that = (GbActivityInfo) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbActivityInfo{" +
                "id='" + id + '\'' +
                ", activityDefinition=" + activityDefinition +
                ", numberNeed=" + numberNeed +
                ", numberGb=" + numberGb +
                ", memo='" + memo + '\'' +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ActivityDefinition getActivityDefinition() {
        return activityDefinition;
    }

    public void setActivityDefinition(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public Integer getNumberNeed() {
        return numberNeed;
    }

    public void setNumberNeed(Integer numberNeed) {
        this.numberNeed = numberNeed;
    }

    public Integer getNumberGb() {
        return numberGb;
    }

    public void setNumberGb(Integer numberGb) {
        this.numberGb = numberGb;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<GbGoods> getGbGoods() {
        return gbGoods;
    }

    public void setGbGoods(List<GbGoods> gbGoods) {
        this.gbGoods = gbGoods;
    }

    public List<GbGroupInfo> getGbGroupInfos() {
        return gbGroupInfos;
    }

    public void setGbGroupInfos(List<GbGroupInfo> gbGroupInfos) {
        this.gbGroupInfos = gbGroupInfos;
    }

    public String getExpiredSynchronize() {
        return expiredSynchronize;
    }

    public void setExpiredSynchronize(String expiredSynchronize) {
        this.expiredSynchronize = expiredSynchronize;
    }
}
