package activities.model.groupbuying;

import activities.model.ActivityGoods;
import activities.model.base.BaseDomain;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.math.BigDecimal;

@Data
@Entity
@Table(indexes =
        {@Index(name = "idx_gb_act_goods_id", columnList = "activity_goods_id"),
                @Index(name = "idx_gb_activity_info_id", columnList = "gb_activity_info_id")})
public class GbGoods extends BaseDomain {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;
    /**
     * 活动商品表 Id
     */
    @JoinColumn(name = "activity_goods_id", foreignKey = @ForeignKey(name = "fk_gb_goods_activity_goods"))
    @OneToOne
    private ActivityGoods activityGoods;

    @JoinColumn(name = "gb_activity_info_id", foreignKey = @ForeignKey(name = "fk_gb_goods_gb_ac_goods"))
    @ManyToOne
    private GbActivityInfo gbActivityInfo;
    /**
     * 拼团价格
     */
    private BigDecimal gbPrice;
    /**
     * 价格类型
     */
    private String priceType;
    /**
     * 是否显示
     */
    private Boolean isDisplay = false;
    /**
     * 排序
     */
    private Integer sortOrder;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbGoods gbGoods = (GbGoods) o;

        return id != null ? id.equals(gbGoods.id) : gbGoods.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbGoods{" +
                "id='" + id + '\'' +
                ", gbPrice=" + gbPrice +
                ", priceType='" + priceType + '\'' +
                ", isDisplay=" + isDisplay +
                ", sortOrder=" + sortOrder +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ActivityGoods getActivityGoods() {
        return activityGoods;
    }

    public void setActivityGoods(ActivityGoods activityGoods) {
        this.activityGoods = activityGoods;
    }

    public GbActivityInfo getGbActivityInfo() {
        return gbActivityInfo;
    }

    public void setGbActivityInfo(GbActivityInfo gbActivityInfo) {
        this.gbActivityInfo = gbActivityInfo;
    }

    public BigDecimal getGbPrice() {
        return gbPrice;
    }

    public void setGbPrice(BigDecimal gbPrice) {
        this.gbPrice = gbPrice;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public Boolean getDisplay() {
        return isDisplay;
    }

    public void setDisplay(Boolean display) {
        isDisplay = display;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }
}
