package activities.model.groupbuying;

import activities.model.base.BaseDomain;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Collection;
import java.util.Date;
@Data
@Entity
@Table(indexes = @Index(name = "indx_gb_group_ac_info_id",columnList = "gb_activity_info_id"))
public class GbGroupInfo extends BaseDomain {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;
    /**
     * 拼团信息表Id
     */
    @JoinColumn(name = "gb_activity_info_id",foreignKey = @ForeignKey(name = "gb_group_activity_info"))
    @ManyToOne
    private GbActivityInfo gbActivityInfo;
    /**
     * 开团时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date groupStartTime;
    /**
     * 截止时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date groupEndTime;
    /**
     * 开团人
     */
    private String memberId;
    /**
     * 已参团人数
     */
    private Integer numberParticipation;
    /**
     * 团状态 0 未成团 1 已成团
     *  {@link GbGroupInfoStatus}
     */
    private String status;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbGroupInfo that = (GbGroupInfo) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbGroupInfo{" +
                "id='" + id + '\'' +
                ", groupStartTime=" + groupStartTime +
                ", groupEndTime=" + groupEndTime +
                ", memberId=" + memberId +
                ", numberParticipation=" + numberParticipation +
                ", status='" + status + '\'' +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GbActivityInfo getGbActivityInfo() {
        return gbActivityInfo;
    }

    public void setGbActivityInfo(GbActivityInfo gbActivityInfo) {
        this.gbActivityInfo = gbActivityInfo;
    }

    public Date getGroupStartTime() {
        return groupStartTime;
    }

    public void setGroupStartTime(Date groupStartTime) {
        this.groupStartTime = groupStartTime;
    }

    public Date getGroupEndTime() {
        return groupEndTime;
    }

    public void setGroupEndTime(Date groupEndTime) {
        this.groupEndTime = groupEndTime;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Integer getNumberParticipation() {
        return numberParticipation;
    }

    public void setNumberParticipation(Integer numberParticipation) {
        this.numberParticipation = numberParticipation;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
