package activities.model.groupbuying;

import activities.model.base.BaseDomain;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;
@Data
@Entity
@Table(indexes = @Index(name = "idx_gb_group_join_info_id",columnList = "gb_group_info_id"))
public class GbGroupJoin extends BaseDomain {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;
    /**
     * 团号
     */
    @JoinColumn(name = "gb_group_info_id", foreignKey = @ForeignKey(name = "fk_gb_join_info"))
    @ManyToOne
    private GbGroupInfo gbGroupInfo;
    /**
     * 用户
     */
    private String memberId;
    /**
     * 是否团长
     */
    private Boolean isLeader = false;
    /**
     * 参团时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateJoin;
    /**
     * 是否参团成功
     */
    private Boolean isDelivery = false;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbGroupJoin that = (GbGroupJoin) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbGroupJoin{" +
                "id='" + id + '\'' +
                ", memberId='" + memberId + '\'' +
                ", isLeader=" + isLeader +
                ", dateJoin=" + dateJoin +
                ", isDelivery=" + isDelivery +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GbGroupInfo getGbGroupInfo() {
        return gbGroupInfo;
    }

    public void setGbGroupInfo(GbGroupInfo gbGroupInfo) {
        this.gbGroupInfo = gbGroupInfo;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Boolean getIsLeader() {
        return isLeader;
    }

    public void setIsLeader(Boolean leader) {
        isLeader = leader;
    }

    public Date getDateJoin() {
        return dateJoin;
    }

    public void setDateJoin(Date dateJoin) {
        this.dateJoin = dateJoin;
    }

    public Boolean getIsDelivery() {
        return isDelivery;
    }

    public void setIsDelivery(Boolean delivery) {
        isDelivery = delivery;
    }
}
