package activities.model.groupbuying;

import activities.model.base.BaseDomain;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Data
@Entity
@Table(indexes = {@Index(name = "idx_gb_order_ac_info_id", columnList = "gb_activity_info_id"),
        @Index(name = "idx_gb_order_group_join_id", columnList = "gb_group_join_id")})
public class GbOrderInfo extends BaseDomain {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;
    /**
     * 拼团活动定义id
     */
    @JoinColumn(name = "gb_activity_info_id", foreignKey = @ForeignKey(name = "fk_gb_order_activity"))
    @ManyToOne
    private GbActivityInfo gbActivityInfo;
    /**
     * 参团记录ID
     */
    @JoinColumn(name = "gb_group_join_id", foreignKey = @ForeignKey(name = "fk_gb_order_group_join"))
    @ManyToOne
    private GbGroupJoin gbGroupJoin;
    /**
     * 购买方式
     */
    private String typeBuy;
    /**
     * 下单来源渠道
     */
    private String channel;
    /**
     * 订单号
     */
    private String orderNo;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GbOrderInfo that = (GbOrderInfo) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "GbOrderInfo{" +
                "id='" + id + '\'' +
                ", type_buy='" + typeBuy + '\'' +
                ", typeBuy='" + channel + '\'' +
                ", orderNo='" + orderNo + '\'' +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GbActivityInfo getGbActivityInfo() {
        return gbActivityInfo;
    }

    public void setGbActivityInfo(GbActivityInfo gbActivityInfo) {
        this.gbActivityInfo = gbActivityInfo;
    }

    public GbGroupJoin getGbGroupJoin() {
        return gbGroupJoin;
    }

    public void setGbGroupJoin(GbGroupJoin gbGroupJoin) {
        this.gbGroupJoin = gbGroupJoin;
    }

    public String getTypeBuy() {
        return typeBuy;
    }

    public void setTypeBuy(String typeBuy) {
        this.typeBuy = typeBuy;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }
}
