package activities.model.repository;

import activities.model.ActivityDefinition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by Admin on 2017/5/17.
 */
public interface ActivityDefinitionRepos extends JpaRepository<ActivityDefinition,String>, JpaSpecificationExecutor<ActivityDefinition> {

    ActivityDefinition findByOrganizationCodeAndIsDelete(String organizationCode,Boolean b);

    List<ActivityDefinition> findByOrganizationCodeAndEndTimeGreaterThanOrderByEndTimeDesc(String organizationCode, Date date);

    List<ActivityDefinition> findByOrganizationCodeAndActivityCodeAndEndTimeGreaterThanOrderByEndTimeDesc( String organizationCode,String activityCode, Date date);

    List<ActivityDefinition> findByOrganizationCodeAndActivityCodeAndEndTimeGreaterThanOrderByBeginTime(String organizationCode, String activityCode, Date time);


    ActivityDefinition findByOrganizationCodeAndActivityCode(String organizationCode,String activityCode);

    List<ActivityDefinition> findByOrganizationCodeAndActivityCodeAndIsOnline(String organizationCode, String activityCode,boolean isOnline, Sort sort);

    @Query(nativeQuery = true, value = "SELECT COUNT(*) FROM ORDER_MAIN OM, ORDER_ITEM OI WHERE OM.ID = OI.ORDER_ID AND OM.IS_DELETE = 0 AND OM.STATUS NOT IN (0, 6, 8, 9) AND OM.MEMBER_ID = ?1 AND OI.ACTIVITY_ID = ?2")
    BigDecimal hasEffectiveOrder(String memberId, String activtyId);
}
