package activities.model.repository;

import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * Created by Admin on 2017/5/17.
 */
public interface ActivityGoodsRepos extends JpaRepository<ActivityGoods, String> {

    List<ActivityGoods> findByGiftClassAndActivityDefinitionId(String giftClass,String activityDefinitionId);

    @Query("select ad.id as activityId, ag.goodsPrice as activityPrice,ag.type as type from ActivityDefinition ad,  ActivityGoods ag where  ad.id=ag.activityDefinition and ag.goodsId=?1 and ad.organizationCode=?2 and ag.isDelete=false and ad.isOnline=true and sysdate>=ad.beginTime and sysdate<=ad.endTime")
    List<Map<String, Object>> findActivityPrice(String goodsId, String organizationCode);

    @Query("SELECT ag.goodsId AS goodsId, ad.id AS activityId, ag.goodsPrice AS activityPrice, ag.type AS type FROM ActivityDefinition ad, ActivityGoods ag WHERE ad.id = ag.activityDefinition AND ag.goodsId IN :goodsIds AND ad.organizationCode = :organizationCode AND ag.isDelete = false AND ad.isOnline = true ORDER BY ad.beginTime")
    List<Map<String, Object>> findActivityPrice(@Param("goodsIds") List<String> goodsIds, @Param("organizationCode") String organizationCode);

    List<ActivityGoods> findByGoodsIdAndActivityDefinitionAndIsDelete(String goodsId, ActivityDefinition activityDefinition, boolean isDelete);

    @Query("SELECT ag FROM ActivityGoods ag, ActivityDefinition ad WHERE ad.id = ag.activityDefinition.id AND ad.isDelete = false AND ag.isDelete = false AND ad.isOnline = true AND ad.organizationCode = :organizationCode AND ad.activityCode = :activityCode AND sysdate < ad.endTime ")
    List<ActivityGoods> findActivityGoods(@Param("organizationCode") String organizationCode, @Param("activityCode") String activityCode);

//    ActivityGoods findByGoodsIdAndActivityDefinitionIdAndIsDelete(String goodsId, String activityInfoId,boolean isDelete);

    ActivityGoods findByGoodsIdAndActivityDefinitionIdAndIsOnlineAndIsDelete(String goodsId, String activityInfoId, boolean isOnline, boolean isDelete);

    @Query("update ActivityGoods set stockNum=stockNum-?3 where activityDefinition.id=?1 and goodsId=?2 and stockNum-?3 >=0")
    @Modifying
    @Transactional
    int countDownGoodsStock(String activityId, String goodsId, Integer number);

    @Query("update ActivityGoods set banNum=banNum-?3 where activityDefinition.id=?1 and goodsId=?2 and banNum-?3>=0")
    @Modifying
    @Transactional
    int countDownGoodsbanNum(String activityId, String goodsId, Integer number);

    @Query("SELECT ag FROM ActivityGoods ag WHERE ag.activityTheme.id = :themeId AND ag.isOnline = :isOnline AND ag.isDelete = :isDelete")
    List<ActivityGoods> findByIsOlineAndIsDeleteAndThemeId(@Param("isOnline") boolean isOnline, @Param("isDelete") boolean isDelete, @Param("themeId") String themeId);
}
