package activities.model.specification;

import activities.model.ActivityDefinition;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.Specification;
import utils.Lang;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Drury
 * @date 2018/5/3
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ActivityDefinitionSpec implements Specification<ActivityDefinition> {

    private ActivityDefinition activityDefinition;

    @Override
    public Predicate toPredicate(Root<ActivityDefinition> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        List<Predicate> predicates = new ArrayList<>();

        // 空判断
        if(!Lang.isEmpty(activityDefinition)) {

            if(!Lang.isEmpty(activityDefinition.getIsOnline())) {
                predicates.add(cb.equal(root.get("isOnline"), activityDefinition.getIsOnline()));
            }

            if(!Lang.isEmpty(activityDefinition.getOrganizationCode())) {
                predicates.add(cb.equal(root.get("organizationCode"), activityDefinition.getOrganizationCode()));
            }

            if(!Lang.isEmpty(activityDefinition.getActivityCode())) {
                predicates.add(cb.equal(root.get("activityCode"), activityDefinition.getActivityCode()));
            }
        }

        // 默认使用false
        predicates.add(cb.equal(root.get("isDelete"), false));

        return query.where(predicates.toArray(new Predicate[predicates.size()])).getRestriction();
    }
}
