package activities.model.specification;

import activities.model.groupbuying.GbGroupJoin;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

public class GbJoinSpecification implements Specification<GbGroupJoin> {
    //原本是要引入dto,但目前api不规范引用中已经引入了model，引入dto会导致循环依赖
    /**
     * 活动定义id(与团id必填一个)
     */
    private String gbActivityInfoId;
    /**
     * 团id
     */
    private String gbGroupInfoId;
    /**
     * 参团人
     */
    private String memberId;

    @Override
    public Predicate toPredicate(Root root, CriteriaQuery query, CriteriaBuilder cb) {
        Predicate predicate = cb.equal(root.get("memberId"), memberId);
        if (!StringUtils.isEmpty(gbActivityInfoId)) {
            predicate = cb.and(predicate, cb.equal(root.get("gbGroupInfo").get("gbActivityInfo").get("id"), gbActivityInfoId));
        }
        if (!StringUtils.isEmpty(gbGroupInfoId)) {
            predicate = cb.and(predicate, cb.equal(root.get("gbGroupInfo").get("id"), gbGroupInfoId));
        }
        predicate = cb.and(predicate, cb.equal(root.get("isDelete"), false));
        return predicate;
    }

    public String getGbActivityInfoId() {
        return gbActivityInfoId;
    }

    public void setGbActivityInfoId(String gbActivityInfoId) {
        this.gbActivityInfoId = gbActivityInfoId;
    }

    public String getGbGroupInfoId() {
        return gbGroupInfoId;
    }

    public void setGbGroupInfoId(String gbGroupInfoId) {
        this.gbGroupInfoId = gbGroupInfoId;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }
}
