/*
 * Decompiled with CFR 0.152.
 */
package activities.model;

import activities.model.ActivityGoods;
import activities.model.ActivityTheme;
import activities.model.base.BaseDomain;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Cacheable(value=true)
public class ActivityDefinition
extends BaseDomain
implements Serializable {
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36)
    protected String id;
    private String organizationCode;
    private String name;
    private String describe;
    private String category;
    @Column(name="begin_time")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date beginTime;
    @Column(name="end_time")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    @Column(name="is_online")
    private Boolean isOnline = true;
    private String activityCode;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="activityDefinition")
    private List<ActivityTheme> activityThemes;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="activityDefinition")
    private List<ActivityGoods> activityGoodses;

    public Boolean getOnline() {
        return this.isOnline;
    }

    public void setOnline(Boolean online) {
        this.isOnline = online;
    }

    public String getActivityCode() {
        return this.activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public List<ActivityGoods> getActivityGoodses() {
        return this.activityGoodses;
    }

    public void setActivityGoodses(List<ActivityGoods> activityGoodses) {
        this.activityGoodses = activityGoodses;
    }

    public List<ActivityTheme> getActivityThemes() {
        return this.activityThemes;
    }

    public void setActivityThemes(List<ActivityTheme> activityThemes) {
        this.activityThemes = activityThemes;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationCode() {
        return this.organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescribe() {
        return this.describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Boolean getIsOnline() {
        return this.isOnline;
    }

    public void setIsOnline(Boolean isOnline) {
        this.isOnline = isOnline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityDefinition that = (ActivityDefinition)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "ActivityDefinition{id='" + this.id + '\'' + ", organizationCode='" + this.organizationCode + '\'' + ", name='" + this.name + '\'' + ", describe='" + this.describe + '\'' + ", category='" + this.category + '\'' + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", isOnline=" + this.isOnline + ", activityCode='" + this.activityCode + '\'' + ", activityThemes=" + this.activityThemes + ", activityGoodses=" + this.activityGoodses + '}';
    }
}

