/*
 * Decompiled with CFR 0.152.
 */
package activities.model.repository;

import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import java.util.List;
import java.util.Map;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface ActivityGoodsRepos
extends JpaRepository<ActivityGoods, String> {
    public List<ActivityGoods> findByGiftClassAndActivityDefinitionId(String var1, String var2);

    @Query(value="select ad.id as activityId, ag.goodsPrice as activityPrice,ag.type as type from ActivityDefinition ad,  ActivityGoods ag where  ad.id=ag.activityDefinition and ag.goodsId=?1 and ad.organizationCode=?2 and ag.isDelete=false and ad.isOnline=true and sysdate>=ad.beginTime and sysdate<=ad.endTime")
    public List<Map<String, Object>> findActivityPrice(String var1, String var2);

    @Query(value="SELECT ag.goodsId AS goodsId, ad.id AS activityId, ag.goodsPrice AS activityPrice, ag.type AS type FROM ActivityDefinition ad, ActivityGoods ag WHERE ad.id = ag.activityDefinition AND ag.goodsId IN :goodsIds AND ad.organizationCode = :organizationCode AND ag.isDelete = false AND ad.isOnline = true ORDER BY ad.beginTime")
    public List<Map<String, Object>> findActivityPrice(@Param(value="goodsIds") List<String> var1, @Param(value="organizationCode") String var2);

    public List<ActivityGoods> findByGoodsIdAndActivityDefinitionAndIsDelete(String var1, ActivityDefinition var2, boolean var3);

    @Query(value="SELECT ag FROM ActivityGoods ag, ActivityDefinition ad WHERE ad.id = ag.activityDefinition.id AND ad.isDelete = false AND ag.isDelete = false AND ad.isOnline = true AND ad.organizationCode = :organizationCode AND ad.activityCode = :activityCode AND sysdate < ad.endTime ")
    public List<ActivityGoods> findActivityGoods(@Param(value="organizationCode") String var1, @Param(value="activityCode") String var2);

    public ActivityGoods findByGoodsIdAndActivityDefinitionIdAndIsOnlineAndIsDelete(String var1, String var2, boolean var3, boolean var4);

    @Query(value="update ActivityGoods set stockNum=stockNum-?3 where activityDefinition.id=?1 and goodsId=?2 and stockNum-?3 >=0")
    @Modifying
    @Transactional
    public int countDownGoodsStock(String var1, String var2, Integer var3);

    @Query(value="update ActivityGoods set banNum=banNum-?3 where activityDefinition.id=?1 and goodsId=?2 and banNum-?3>=0")
    @Modifying
    @Transactional
    public int countDownGoodsbanNum(String var1, String var2, Integer var3);

    @Query(value="SELECT ag FROM ActivityGoods ag WHERE ag.activityTheme.id = :themeId AND ag.isOnline = :isOnline AND ag.isDelete = :isDelete")
    public List<ActivityGoods> findByIsOlineAndIsDeleteAndThemeId(@Param(value="isOnline") boolean var1, @Param(value="isDelete") boolean var2, @Param(value="themeId") String var3);
}

