package activities.service.activities.dao.impl;

import activities.service.activities.dao.ActivitiesDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by zhangtao on 2017/9/28.
 */
@Repository
@Transactional
public class ActivitiesDaoImpl implements ActivitiesDao{

    @Autowired
    EntityManager entityManager;

    @Override
    public Integer getCountByGoodsIdAndActityId(String goodsId,String activityId){

        String sql="select count(*) from \n" +
                "  (select  distinct main.member_id from order_main main,order_item item,activity_definition ad \n" +
                "   where main.id = item.order_id \n" +
                "   and item.activity_id = ad.id \n" +
                "   and item.goods_id = ?1 \n" +
                "   and item.activity_id = ?2)";
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter(1,goodsId);
        query.setParameter(2,activityId);
        List<BigDecimal> count = query.getResultList();
        Integer total = 0;
        if(!Lang.isEmpty(count) && !Lang.isEmpty(count.get(0))){
            total = count.get(0).intValue();
        }
        return total;
    }
}
