package activities.service.apiImpl;

import activities.api.ActivityDefinitionApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.model.ActivityDefinition;
import activities.model.repository.ActivityDefinitionRepos;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import utils.Lang;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by Dy on 2018-03-06.
 */
@MotanService
public class ActivityDefinitionApiImpl implements ActivityDefinitionApi {

    @Autowired
    ActivityDefinitionRepos activityDefinitionRepos;
    @Autowired
    MapperFacade mapperFacade;

    @Override
    public List<ActivityDefinitionDto> findByOrganizationCodeAndActivityCode(String organizationCode, String activityCode) {
        List<ActivityDefinition> activityDefinitions = activityDefinitionRepos.findByOrganizationCodeAndActivityCodeAndIsOnline(organizationCode, activityCode, true, new Sort(Sort.Direction.ASC, "beginTime"));
        activityDefinitions = activityDefinitions.stream().filter(activityDefinition -> !activityDefinition.getIsDelete()).collect(Collectors.toList());
        return mapperFacade.mapAsList(activityDefinitions, ActivityDefinitionDto.class);
    }

}
