package activities.service.apiImpl;

import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import activities.model.ActivityTheme;
import activities.model.repository.ActivityDefinitionRepos;
import activities.model.repository.ActivityThemeRepos;
import activities.service.service.ActivityService;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.api.ProductFashionApi;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import member.api.MemberAddressApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import utils.Lang;
import utils.data.BeanMapper;
import utils.lang.Copys;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by renjunlin on 2017/7/4.
 */
@Slf4j
@MotanService
public class ActivityImpl implements ActivityApi {

    @Autowired
    ActivityDefinitionRepos activityDefinitionRepos;
    @Autowired
    ActivityThemeRepos activityThemeRepos;

    @Autowired
    ActivityConfigurationApi activityConfigurationApi;

    @Autowired
    MapperFacade mapperFacade;

    @Autowired
    private ActivityService activityService;

    @Override
    public ActivityDefinitionDto findByOrganizationCodeAndActivityCode(String organizationCode, String activityCode) {
        ActivityDefinition activityDefinition = activityDefinitionRepos.findByOrganizationCodeAndActivityCode(organizationCode, activityCode);
        copyValueForActivityDefinition(activityDefinition);

        return BeanMapper.map(activityDefinition,ActivityDefinitionDto.class);
//        return activityDefinitionRepos.findByChannelAndActivityCode(channel, activityCode);
    }

    public void copyValueForActivityDefinition(ActivityDefinition activityDefinition) {
        List<ActivityTheme> activityThemeList = new ArrayList<>();
        List<ActivityGoods> activityGoodsList = new ArrayList<>();
        if (activityDefinition != null) {
            if (activityDefinition.getActivityThemes() != null) {
                for (ActivityTheme activityTheme : activityDefinition.getActivityThemes()) {
                    ActivityTheme activityTheme1 = new ActivityTheme();
                    Copys.create().excludes("activityDefinition").from(activityTheme).to(activityTheme1);
                    activityThemeList.add(activityTheme1);
                }
                activityDefinition.setActivityThemes(activityThemeList);
            }
            if (activityDefinition.getActivityGoodses() != null) {
                for (ActivityGoods activityGoods : activityDefinition.getActivityGoodses()) {
                    ActivityGoods activityGoods1 = new ActivityGoods();
                    Copys.create().excludes("activityDefinition").from(activityGoods).to(activityGoods1);
                    activityGoodsList.add(activityGoods1);
                }
                activityDefinition.setActivityGoodses(activityGoodsList);
            }
        }
    }

    @Override
    public List<ActivityDefinitionDto> findSecKillActivity(String organizationCode, String activityCode) {
        List<ActivityDefinition> list = activityDefinitionRepos.findByOrganizationCodeAndActivityCodeAndIsOnline(organizationCode, activityCode, true, new Sort(Sort.Direction.ASC, "beginTime"));
        List<ActivityDefinition> activityDefinitions = new ArrayList<>();
        for (ActivityDefinition activityDefinition : list) {
            if(!Lang.isEmpty(activityDefinition.getEndTime())) {
                if(activityDefinition.getEndTime().before(new Date())) {
                    activityDefinition.setIsOnline(false);
                    activityDefinitionRepos.saveAndFlush(activityDefinition);
                } else {
                    activityDefinitions.add(activityDefinition);
                }
            }
        }
        // 清除缓存数据
        if(list.size() != 0 && activityDefinitions.size() == 0) {
            List<String> activityCodeList = new ArrayList<>();
            activityCodeList.add(activityCode);
            activityConfigurationApi.reload(organizationCode, activityCodeList);
        }
        return mapperFacade.mapAsList(activityDefinitions, ActivityDefinitionDto.class);
    }

    @Override
    public ActivityDefinitionDto findById(String id) {
        ActivityDefinition activityDefinition = activityDefinitionRepos.findOne(id);
        copyValueForActivityDefinition(activityDefinition);
        return BeanMapper.map(activityDefinition,ActivityDefinitionDto.class);
    }

    /**
     * �û��Ƿ�μӻ���ɹ��µ�
     *
     * @param memberId  �û�ID
     * @param activtyId �ID
     */
    @Override
    public boolean hasEffectiveOrder(String memberId, String activtyId) {
        BigDecimal count = activityDefinitionRepos.hasEffectiveOrder(memberId, activtyId);
        return count.intValue() > 0;
    }

    /**
     * ���ν�����ΪʧЧ״̬
     *
     * @param activtyId �ID
     */
    @Override
    public void setActivityDefinitionIsOnline(String activtyId) {
        ActivityDefinition activityDefinition = activityDefinitionRepos.findOne(activtyId);
        copyValueForActivityDefinition(activityDefinition);
        activityDefinition.setIsOnline(false);
        activityDefinitionRepos.save(activityDefinition);
    }

    @Override
    public ActivityDefinitionDto findByOrganizationCode(String organizationCode,String ctAtivityCode) {
        ActivityDefinition activityDefinition = activityDefinitionRepos.findByOrganizationCodeAndActivityCode(organizationCode,ctAtivityCode);
        return BeanMapper.map(activityDefinition,ActivityDefinitionDto.class);
    }

    /**
     * 根据样例数据查询活动场次
     *
     * @param activityDefinitionDto activityDefinitionDto
     * @return  List<ActivityDefinitionDto>
     */
    @Override
    public List<ActivityDefinitionDto> findByExample(ActivityDefinitionDto activityDefinitionDto) {
        return activityService.findByExample(activityDefinitionDto);
    }

    /**
     * 保存或更新
     *
     * @param activityDefinitionDto ActivityDefinitionDto
     * @return ActivityDefinitionDto
     */
    @Override
    public ActivityDefinitionDto saveOrUpdate(ActivityDefinitionDto activityDefinitionDto) {
        return activityService.saveOrUpdate(activityDefinitionDto);
    }


}
