package activities.service.apiImpl;

import activities.api.ActivityThemeApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.ActivityThemeDto;
import activities.model.ActivityDefinition;
import activities.model.ActivityTheme;
import activities.model.repository.ActivityThemeRepos;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import utils.Lang;

/**
 * Created by Dy on 2018-03-06.
 */
@MotanService
public class ActivityThemeApiImpl implements ActivityThemeApi {

    @Autowired
    ActivityThemeRepos activityThemeRepos;

    @Autowired
    MapperFacade mapperFacade;

    @Override
    public ActivityThemeDto findByShowIndexAndActivityDefinitionAndIsDelete(Integer themeIndex, ActivityDefinitionDto activityDefinitionDto, Boolean bool) {
        ActivityTheme activityTheme = activityThemeRepos.findByShowIndexAndActivityDefinitionAndIsDelete(themeIndex,mapperFacade.map(activityDefinitionDto, ActivityDefinition.class),bool);
        if (Lang.isEmpty(activityTheme)) {
            return null;
        }
        return mapperFacade.map(activityTheme,ActivityThemeDto.class);
    }
}
