package activities.service.apiImpl;

import activities.api.GroupBuyingApi;
import activities.dto.activity.request.OrderRequstVo;
import activities.dto.activity.response.OrderResponseVo;
import activities.dto.groupbuying.request.*;
import activities.dto.groupbuying.response.*;
import activities.model.groupbuying.GbOrderInfo;
import activities.service.service.GroupBuyingService;
import cart.api.dto.payment.PaymentReturnVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import sinomall.config.api.base.BaseResponse;
import utils.GlobalContants;
import utils.Lang;
import utils.lock.RedisLockUtil;

@MotanService
public class GroupBuyingApiImpl implements GroupBuyingApi {
    Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    GroupBuyingService groupBuyingService;

    @Autowired
    RedisLockUtil redisLockUtil;

    @Autowired
    MapperFacade mapperFacade;


    @Override
    public GroupBuyingGoodsRespDto queryGroupBuyingGoodsPrice(GroupBuyingGoodsReqDto groupBuyingGoodsReqDto) {
        return groupBuyingService.queryGroupBuyingGoodsPrice(groupBuyingGoodsReqDto);
    }

    @Override
    public GbGroupJoinRespDto queryGbGroupJoinNumber(GbGroupJoinReqDto gbGroupJoinReqDto) {
        return groupBuyingService.queryGbGroupJoinNumber(gbGroupJoinReqDto);
    }

    @Override
    public OrderResponseVo createOrder(OrderRequstVo orderRequstVo) {
        return groupBuyingService.createOrder(orderRequstVo);

    }

    @Override
    public GroupInfoHandleResponseDto handleGroupInfo(GroupInfoHandleRequestDto hanleGroupRequestDto) {
        try {
            //团id做锁处理
            if (!StringUtils.isEmpty(hanleGroupRequestDto.getGbGroupId())) {
                redisLockUtil.lock(GROUP_REDIS_KEY + hanleGroupRequestDto.getGbGroupId());
            }
            return groupBuyingService.handleGroupInfo(hanleGroupRequestDto);
        } catch (Exception e) {
            logger.error("处理团信息失败", e);
            throw e;
        } finally {
            if (!StringUtils.isEmpty(hanleGroupRequestDto.getGbGroupId())) {
                redisLockUtil.unlock(GROUP_REDIS_KEY + hanleGroupRequestDto.getGbGroupId());
            }
        }

    }

    @Override
    public BaseResponse cancelGbOrder(String orderNo) {
        GbOrderInfo gbOrderInfo = groupBuyingService.findByOrderNo(orderNo);
        if (gbOrderInfo != null) {
            String groupInfoId = "";
            try {
                redisLockUtil.lock(GROUP_REDIS_KEY + ":order:" + gbOrderInfo.getOrderNo());
                if (gbOrderInfo.getGbGroupJoin() != null && gbOrderInfo.getGbGroupJoin().getGbGroupInfo() != null) {
                    groupInfoId = gbOrderInfo.getGbGroupJoin().getGbGroupInfo().getId();
                    redisLockUtil.lock(GroupBuyingApi.GROUP_REDIS_KEY + ":group:" + groupInfoId);
                }
                return groupBuyingService.cancelGbOrder(gbOrderInfo);
            } catch (Exception e) {
                logger.error("取消团购订单失败", e);
                return new BaseResponse(GlobalContants.ResponseStatus.ERROR, "拼团订单取消失败");
            } finally {
                redisLockUtil.unlock(GROUP_REDIS_KEY + ":order:" + gbOrderInfo.getOrderNo());
                redisLockUtil.unlock(GroupBuyingApi.GROUP_REDIS_KEY + ":group:" + groupInfoId);
            }
        }
        return new BaseResponse(GlobalContants.ResponseStatus.SUCCESS, "该订单不是拼团订单");
    }

    @Override
    public BaseResponse gbPayback(activities.vo.payment.PaymentReturnVo paymentReturnVoParam) {
        PaymentReturnVo paymentReturnVo = Lang.isEmpty(paymentReturnVoParam) ? null : mapperFacade.map(paymentReturnVoParam, PaymentReturnVo.class);
        return groupBuyingService.gbPayback(paymentReturnVo);
    }

    @Override
    public GbOrderInfoDto queryGroupOrderInfo(String orderNo) {
        return groupBuyingService.queryGroupOrderInfo(orderNo);
    }

    @Override
    public String findOrderNoByMemberIdAndGroupId(String memberId, String groupId) {
        return groupBuyingService.findOrderNoByMemberIdAndGroupId(memberId, groupId);
    }

    @Override
    public GbGroupInfoRespDto queryGbGroupInfo(GbGroupInfoReqDto gbGroupInfoReqDto) {
        return groupBuyingService.queryGbGroupInfoRespDto(gbGroupInfoReqDto);
    }

    /**
     * 查询活动信息
     */
    @Override
    public GbActivityInfoRespDto queryGbActivityInfoById(GbActivityInfoReqDto gbActivityInfoReqDto) {
        return groupBuyingService.queryGbActivityInfoRespDto(gbActivityInfoReqDto);
    }

    /**
     * 定时扫描处理过期未成团的团
     */
    @Override
    public void queryActivityGroupStatusAndHandle() {
        groupBuyingService.queryActivityGroupStatusAndHandle();
    }
}
