package activities.service.config;

import activities.service.service.ActivityGoodsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

import javax.annotation.PostConstruct;
import java.util.Set;

//@Configuration
public class ActivityConfig {

    @Autowired
    ActivityGoodsService activityGoodsService;

    @Autowired
    private RedisTemplate redisTemplate;

    @Value("${itaipingMobile.organization.code}")
    private String itaipingMobileOrganizationCode;

    @Value("${itaipingPC.organization.code}")
    private String itaipingPCOrganizationCode;

    //秒杀
    @Value("${secKillActivity.activityCode}")
    private String secKillActivityCode;

    //团购
    @Value("${tuanGouActivity.activityCode}")
    private String tuanGouActivityCode;


    /**
     * 初始活动商品库存
     * 范围：移动端、PC端
     * 活动：秒杀、团购
     * FOR ITAIPING 购物
     */
    /*@PostConstruct
    public void initActivityGoodsStock() {
        //移动端
        String mobileKey = itaipingMobileOrganizationCode + ":" + "activityStock*";
        Set<String> mobileSet = redisTemplate.keys(mobileKey);
        redisTemplate.delete(mobileSet);
        activityGoodsService.loadStockToCache(itaipingMobileOrganizationCode, secKillActivityCode);
        activityGoodsService.loadStockToCache(itaipingMobileOrganizationCode, tuanGouActivityCode);

        //PC端
        String pcKey = itaipingPCOrganizationCode + ":" + "activityStock*";
        Set<String> PCSet = redisTemplate.keys(pcKey);
        redisTemplate.delete(PCSet);
        activityGoodsService.loadStockToCache(itaipingPCOrganizationCode, secKillActivityCode);
        activityGoodsService.loadStockToCache(itaipingPCOrganizationCode, tuanGouActivityCode);

    }*/


}
