package activities.service.config;

import activities.service.hibernate.CacheEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.SessionFactoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

import javax.persistence.EntityManagerFactory;

/**
 * Created by xiaoqian on 2016/9/27.
 */
@Configuration
@ComponentScan("utils.sql")
@EntityScan(basePackages = {"tp.score.model","activities.model", "goods.model"})
@EnableJpaRepositories(basePackages = {"tp.score.model.repository","activities.model.repository", "goods.model.repository"})
public class JpaConfig {

    @Autowired
    private EntityManagerFactory entityManagerFactory;

    //@Bean
    CacheEventListener cacheEventListener(){
        return new CacheEventListener();
    }

    //@PostConstruct
    public void registerListeners() {
        SessionFactory sessionFactory = entityManagerFactory.unwrap(SessionFactory.class);
        CacheEventListener cacheEventListener = cacheEventListener();
        EventListenerRegistry registry = ((SessionFactoryImpl) sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
        registry.getEventListenerGroup(EventType.POST_INSERT).appendListener(cacheEventListener);
        registry.getEventListenerGroup(EventType.POST_UPDATE).appendListener(cacheEventListener);
        registry.getEventListenerGroup(EventType.POST_DELETE).appendListener(cacheEventListener);
    }

}
