package activities.service.service.impl;

import activities.dto.activity.request.ActivityGoodsReqDto;
import activities.dto.activity.response.ActivityGoodsRespDto;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.model.ActivityDefinition;
import activities.model.repository.ActivityDefinitionRepos;
import activities.service.service.ActivityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.stereotype.Service;
import utils.data.BeanMapper;

import java.util.List;

/**
 * 活动 service
 *
 * @author Drury
 */
@Slf4j
@Service
public class ActivityServiceImpl implements ActivityService {

    @Override
    public ActivityGoodsRespDto isActivityGoodsAndGetActivityPrice(ActivityGoodsReqDto activityGoodsReqDto) {
        // TODO: 2018-01-13 未实现，待重构
        return null;
    }

    /**
     * 根据样例数据查询活动场次
     *
     * @param activityDefinitionDto activityDefinitionDto
     * @return  List<ActivityDefinitionDto>
     */
    @Override
    public List<ActivityDefinitionDto> findByExample(ActivityDefinitionDto activityDefinitionDto) {
        ActivityDefinition activityDefinition = BeanMapper.map(activityDefinitionDto, ActivityDefinition.class);
        List<ActivityDefinition> activityDefinitions = activityDefinitionRepos.findAll(createExample(activityDefinition));
        return BeanMapper.mapList(activityDefinitions, ActivityDefinition.class, ActivityDefinitionDto.class);
    }

    /**
     * 保存或更新
     *
     * @param activityDefinitionDto ActivityDefinitionDto
     * @return ActivityDefinitionDto
     */
    @Override
    public ActivityDefinitionDto saveOrUpdate(ActivityDefinitionDto activityDefinitionDto) {
        ActivityDefinition activityDefinition = BeanMapper.map(activityDefinitionDto, ActivityDefinition.class);
        activityDefinition = activityDefinitionRepos.save(activityDefinition);
        return BeanMapper.map(activityDefinition, ActivityDefinitionDto.class);
    }

    private Example<ActivityDefinition> createExample(ActivityDefinition entity) {
        ExampleMatcher matcher = ExampleMatcher.matching().withIgnoreNullValues();
        return Example.of(entity, matcher);
    }

    private final ActivityDefinitionRepos activityDefinitionRepos;

    @Autowired
    public ActivityServiceImpl(ActivityDefinitionRepos activityDefinitionRepos) {
        this.activityDefinitionRepos = activityDefinitionRepos;
    }
}
