package activities.service.service.impl;

import activities.api.ActivityGoodsApi;
import activities.definition.*;
import activities.dto.activity.request.ActivityGoodsReqDto;
import activities.dto.activity.request.OrderRequstVo;
import activities.dto.activity.response.ActivityGoodsRespDto;
import activities.dto.activity.response.OrderResponseVo;
import activities.dto.groupbuying.request.*;
import activities.dto.groupbuying.response.*;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.groupbuying.GbActivityInfoDto;
import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import activities.model.groupbuying.*;
import activities.model.repository.*;
import activities.model.specification.GbJoinSpecification;
import activities.service.service.GroupBuyingService;
import cart.api.OrderItemApi;
import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.payment.PaymentDto;
import cart.api.dto.payment.PaymentReturnVo;
import cart.api.dto.response.PayResultDto;
import cart.api.vo.FashionDetailVo;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductFashionApi;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsDto;
import goods.model.Goods;
import goods.model.repository.GoodsRepos;
import goods.vo.FashionIdAndCountVo;
import goods.vo.SalesPriceQueryVo;
import ma.glasnost.orika.MapperFacade;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.vo.MemberAddressVo;
import member.api.vo.response.MemberAddressResponseVo;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import sinomall.config.api.base.BaseResponse;
import store.api.StoreApi;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.lang.Copys;
import utils.lock.RedisLockUtil;

import java.math.BigDecimal;
import java.util.*;


@Service
public class GroupBuyingServiceImpl implements GroupBuyingService {
    Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    GbActivityInfoRepo gbActivityInfoRepo;
    @Autowired
    GbGoodsRepo gbGoodsRepo;
    @Autowired
    GbGroupInfoRepo gbGroupInfoRepo;
    @Autowired
    GbGroupJoinRepo gbGroupJoinRepo;
    @Autowired
    GoodsRepos goodsRepos;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @Autowired
    ActivityGoodsRepos activityGoodsRepos;
    @Autowired
    GbOrderInfoRepo gbOrderInfoRepo;
    @Autowired
    RedisLockUtil redisLockUtil;
    @MotanReferer
    OrderItemApi orderItemApi;
    @MotanReferer
    PaymentApi paymentApi;
    @Autowired
    MapperFacade mapperFacade;

    @Override
    public GroupBuyingGoodsRespDto queryGroupBuyingGoodsPrice(GroupBuyingGoodsReqDto groupBuyingGoodsReqDto) {
        GbGoods gbGoods = gbGoodsRepo.findByGbActivityInfoIdAndActivityGoodsGoodsIdAndIsDelete(groupBuyingGoodsReqDto.getGbActivityInfoId(), groupBuyingGoodsReqDto.getGoodsId(), false);
        GroupBuyingGoodsRespDto groupBuyingGoodsRespDto = new GroupBuyingGoodsRespDto();
        if (gbGoods != null) {
            ActivityGoods activityGoods = gbGoods.getActivityGoods();
            ActivityDefinition activityDefinition = activityGoods.getActivityDefinition();
            BigDecimal groupBuyinlPrice = null;
            Goods goodsPO = goodsRepos.findOne(groupBuyingGoodsReqDto.getGoodsId());
            GoodsDto goods = new GoodsDto();
            Copys.create().from(goodsPO).excludes("product", "goodsAttrs", "goodsPictures", "goodsFashions", "goodsParams", "productFashion").to(goods).clear();
            switch (ActivityPriceType.activityPriceTypeMap.get(gbGoods.getPriceType())) {
                case ratePrcie:
                    String storeCode = storeApi.findStoreCodeById(goods.getStoreId());
                    SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(activityDefinition.getOrganizationCode(), storeCode, goods);
                    List<Map> mapList = salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(salesPriceQueryVo));
                    if (!Lang.isEmpty(mapList)) {
                        groupBuyinlPrice = (BigDecimal) mapList.get(0).get("salePrice");
                    }
                    break;
                case negotiatedPrice:
                    groupBuyinlPrice = goodsRepos.findCostPriceById(groupBuyingGoodsReqDto.getGoodsId());
                case configurationPrice:
                    groupBuyinlPrice = gbGoods.getGbPrice();
            }
            groupBuyingGoodsRespDto.setGroupBuyinlPrice(groupBuyinlPrice);
            groupBuyingGoodsRespDto.setBanNum(activityGoods.getBanNum());
            groupBuyingGoodsRespDto.setSoldNum(activityGoods.getSoldNum());
            groupBuyingGoodsRespDto.setStockNum(activityGoods.getStockNum());
            ActivityGoodsReqDto activityGoodsReqDto = new ActivityGoodsReqDto();
            activityGoodsReqDto.setActivityInfoId(activityDefinition.getId());
            activityGoodsReqDto.setGoodsId(groupBuyingGoodsReqDto.getGoodsId());
            ActivityGoodsRespDto activityGoodsRespDto = activityGoodsApi.isActivityGoodsAndGetActivityPrice(activityGoodsReqDto);
            groupBuyingGoodsRespDto.setNormalPrice(activityGoodsRespDto.getActivitylPrice());
            groupBuyingGoodsRespDto.setActivityDefinitionType(activityGoodsRespDto.getActivityDefinitionType());
        } else {
            groupBuyingGoodsRespDto.setActivityDefinitionType(ActivityDefinitionType.noExist);
        }
        return groupBuyingGoodsRespDto;
    }

    @Override
    public GbGroupInfoRespDto queryGbGroupInfoRespDto(GbGroupInfoReqDto gbGroupInfoReqDto) {
        GbGroupInfo gbGroupInfo = gbGroupInfoRepo.findOne(gbGroupInfoReqDto.getGroupId());
        if (gbGroupInfo != null) {
            GbGroupInfoRespDto gbGroupInfoRespDto = new GbGroupInfoRespDto();
            gbGroupInfoRespDto.setGroupStartTime(gbGroupInfo.getGroupStartTime());
            gbGroupInfoRespDto.setGroupEndTime(gbGroupInfo.getGroupEndTime());
            gbGroupInfoRespDto.setNumberParticipation(gbGroupInfo.getNumberParticipation());
            GbActivityInfo gbActivityInfo = gbGroupInfo.getGbActivityInfo();
            gbGroupInfoRespDto.setTotalNumber(gbActivityInfo.getNumberNeed());
            gbGroupInfoRespDto.setGbActivityInfoId(gbActivityInfo.getId());
            gbGroupInfoRespDto.setGbGroupInfoStatus(GbGroupInfoStatus.gbGroupInfoStatusHashMap.get(gbGroupInfo.getStatus()));
            ActivityDefinition activityDefinition = gbActivityInfo.getActivityDefinition();
            ActivityDefinitionType activityDefinitionType = activityGoodsApi.getActivityDefinitionType(BeanMapper.map(activityDefinition, ActivityDefinitionDto.class));
            gbGroupInfoRespDto.setActivityDefinitionType(activityDefinitionType);
            return gbGroupInfoRespDto;
        }
        return null;
    }

    @Override
    public GbGroupJoinRespDto queryGbGroupJoinNumber(GbGroupJoinReqDto gbGroupJoinReqDto) {
        GbGroupJoinRespDto gbGroupJoinRespDto = new GbGroupJoinRespDto();
        gbGroupJoinRespDto.setJoinNumber(0);
        GbJoinSpecification gbJoinSpecification = new GbJoinSpecification();
        gbJoinSpecification.setGbActivityInfoId(gbGroupJoinReqDto.getGbActivityInfoId());
        gbJoinSpecification.setGbGroupInfoId(gbGroupJoinReqDto.getGbGroupInfoId());
        gbJoinSpecification.setMemberId(gbGroupJoinReqDto.getMemberId());
        List<GbGroupJoin> gbGroupJoins = gbGroupJoinRepo.findAll(gbJoinSpecification);
        if (gbGroupJoins != null && !gbGroupJoins.isEmpty()) {
            gbGroupJoinRespDto.setJoinNumber(gbGroupJoins.size());
        }
        for (GbGroupJoin gbGroupJoin : gbGroupJoins) {
            if (gbGroupJoin.getIsLeader()) {
                gbGroupJoinRespDto.setIsLeader(true);
                break;
            }
        }
        return gbGroupJoinRespDto;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @Override
    public OrderResponseVo createOrder(OrderRequstVo orderRequstVo) {
        GbActivityInfo gbActivityInfo = null;
        if (!StringUtils.isEmpty(orderRequstVo.getActivityInfoId())) {
            gbActivityInfo = gbActivityInfoRepo.findOne(orderRequstVo.getActivityInfoId());
        } else if (!StringUtils.isEmpty(orderRequstVo.getGbGroupId())) {
            GbGroupInfo gbGroupInfo = gbGroupInfoRepo.findOne(orderRequstVo.getGbGroupId());
            gbActivityInfo = gbGroupInfo.getGbActivityInfo();
        } else {
            throw new RuntimeException("参数不正确，activityInfoId与gbGroupId不能都为空");
        }
        String activityId = gbActivityInfo.getActivityDefinition().getId();
        try {
            long start = System.currentTimeMillis();
            MemberAddressVo memberAddressVo = Lang.isEmpty(orderRequstVo.getMemberAddressVo()) ? null : mapperFacade.map(orderRequstVo.getMemberAddressVo(), MemberAddressVo.class);
            MemberAddressResponseVo memberAddressResponseVo = memberAddressApi.saveOrUpdateAddress(memberAddressVo);
            logger.info("拼团处理地址信息耗时:{}", System.currentTimeMillis() - start);
            if (!BaseResponse.SUCCESS.equals(memberAddressResponseVo.getBaseResponse().getStatus())) {
                logger.error("===============保存地址出错==========");
                new RuntimeException("保存地址出错");
            }
            String productFashionIdStr = orderRequstVo.getProductFashionIdStr();
            String countsStr = orderRequstVo.getCountsStr();
            String goodsIdStr = orderRequstVo.getGoodsIdStr();
            if (!Lang.isEmpty(productFashionIdStr) && !Lang.isEmpty(countsStr)) {
                /** 使用productFashion直接生成临时订单 */   //用法不好，容易出错
                String[] productFashionIds = productFashionIdStr.split(",");
                String[] buyCounts = countsStr.split(",");
                String[] goodsIds = goodsIdStr.split(",");
                List<FashionIdAndCountVo> fashionIdAndCountVoList = new ArrayList<>();
                List<String> fashionIdList = new ArrayList<>();
                List<Integer> fashionCountList = new ArrayList<>();
                for (int i = 0; i < productFashionIds.length; i++) {
                    if (!Lang.isEmpty(productFashionIds[i])) {
                        fashionIdList.add(productFashionIds[i].trim());
                        fashionCountList.add(Integer.parseInt(buyCounts[i]));
                        fashionIdAndCountVoList.add(new FashionIdAndCountVo(productFashionIds[i].trim(), goodsIds[i].trim(), Integer.parseInt(buyCounts[i])));
                    }
                }
                start = System.currentTimeMillis();
                /** 查询库存状态 */
                Map stockQueyrRes = productFashionApi.queryFashionStockStatus(fashionIdAndCountVoList, orderRequstVo.getAreaCode(), orderRequstVo.getOrganizationCode());
                boolean noStockFlag = true; // 包含无库存状态商品标志
                logger.info("拼团查询库存耗时:{}", System.currentTimeMillis() - start);
                if (GlobalContants.ResponseStatus.SUCCESS.equals((String) stockQueyrRes.get(GlobalContants.ResponseString.STATUS))) {
                    noStockFlag = noStockFlag && (Boolean) ((Map) stockQueyrRes.get(GlobalContants.ResponseString.DATA)).get("noStockFlag");
                } else {
                    noStockFlag = noStockFlag && false;
                }
                if (!noStockFlag) {
                    start = System.currentTimeMillis();
                    List<FashionDetailVo> fashionDetailVos = mapperFacade.mapAsList(fashionIdAndCountVoList, FashionDetailVo.class);
                    TempOrderVo tempOrderVo = orderMainApi.newTempOrderByFasions(fashionDetailVos, orderRequstVo.getOrganizationCode(), orderRequstVo.getAreaCode());
                    logger.info("拼团创建临时订单耗时:{}", System.currentTimeMillis() - start);
                    //处理活动商品拼团价格
//                    BigDecimal totalShippingFee = new BigDecimal(0);
                    for (TempOrderStoreVo tempOrderStoreVo : tempOrderVo.getStoreList()) {
                        for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                            GbGoods gbGoods = gbGoodsRepo.findByGbActivityInfoIdAndActivityGoodsGoodsIdAndIsDelete(gbActivityInfo.getId(), tempOrderItemVo.getGoodsId(), false);
                            if (ActivityBuyWayDefinitionType.gbBuy.equals(orderRequstVo.getActivityBuyWayDefinitionType()) || ActivityBuyWayDefinitionType.createGbBuy.equals(orderRequstVo.getActivityBuyWayDefinitionType())) {
                                tempOrderItemVo.setSalePrice(gbGoods.getGbPrice());
                            } else if (ActivityBuyWayDefinitionType.gbSingleBuy.equals(orderRequstVo.getActivityBuyWayDefinitionType())) {
                                tempOrderItemVo.setSalePrice(gbGoods.getActivityGoods().getGoodsPrice());
                            }
                        }
//                        BigDecimal shippingFee = orderMainApi.queryShippingFee(tempOrderStoreVo.getStoreId(), tempOrderStoreVo.getOrderItems(), memberAddressResponseVo.getMemberAddressId());
//                        totalShippingFee.add(shippingFee);
                    }
                    tempOrderVo.setRealOrganizationId(organizationApi.findOrganizationByOrgCode(orderRequstVo.getOrganizationCode()).getId());
//                    tempOrderVo.setSumShippingFee(totalShippingFee);
                    //扣减校验活动商品库存
                    for (TempOrderStoreVo tempOrderStoreVo : tempOrderVo.getStoreList()) {
                        for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                            int downGoodsStock = activityGoodsRepos.countDownGoodsStock(activityId, tempOrderItemVo.getGoodsId(), tempOrderItemVo.getCount());
                            if (downGoodsStock == 0) {
                                logger.error("库存不足========activityId={},goodsId={},count={}", activityId, tempOrderItemVo.getGoodsId(), tempOrderItemVo.getCount());
                                return new OrderResponseVo(BaseResponse.ERROR, "activityGood stock overed");
                            }
                        }
                    }
                    /**
                     * todo 查询购买数量是否超过个人购买数量最大值
                     */
                    //创建订单
                    String userId = memberApi.getMemberInfo(orderRequstVo.getMemberId()).getUser().getId();
                    start = System.currentTimeMillis();
                    Map<String, Object> ordersInfoMap = orderMainApi.createOrder(tempOrderVo, memberAddressResponseVo.getMemberAddressId(), userId, orderRequstVo.getMemberId(), orderRequstVo.getPayMethodCode());
                    logger.info("拼团创建主订单耗时:{}", System.currentTimeMillis() - start);
                    if (!GlobalContants.ResponseStatus.ERROR.equals(ordersInfoMap.get(GlobalContants.ResponseString.STATUS))) {
                        Map resData = (Map) ordersInfoMap.get("data");
                        List<OrderMainDto> sucOrders = (List<OrderMainDto>) resData.get("sucOrderList");
                        StringBuilder orderNos = new StringBuilder();
                        for (OrderMainDto sucOrder : sucOrders) {
                            orderNos.append(sucOrder.getOrderNo()).append(",");
                        }
                        return new OrderResponseVo(BaseResponse.SUCCESS, BaseResponse.SUCCESS_MESSAGE, orderNos.substring(0, orderNos.length() - 1));
                    }
                } else {
                    /** 错误3，库存出错 */
                    logger.info("下单失败库存不足 请求参数 = {}", JSON.toJSONString(orderRequstVo));
                    return new OrderResponseVo(BaseResponse.ERROR, "Overed Stock!");
                }
            } else {
                logger.error("===============商品信息有误==========");
                new RuntimeException("商品信息有误");
            }
        } catch (Exception e) {
            logger.error("创建订单失败 orderRequstVo={}========", JSON.toJSON(orderRequstVo), e);
            throw e;
        }

        return new OrderResponseVo(BaseResponse.ERROR, BaseResponse.ERROR_MESSAGE);

    }

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @Override
    public GroupInfoHandleResponseDto handleGroupInfo(GroupInfoHandleRequestDto handleGroupRequestDto) {
        GroupInfoHandleResponseDto gbGroupInfoHandleResponseDto = new GroupInfoHandleResponseDto();
        gbGroupInfoHandleResponseDto.setStatus(GlobalContants.ResponseStatus.SUCCESS);
        gbGroupInfoHandleResponseDto.setResponseMsg("调用成功");
        GbGroupInfo gbGroupInfo = null;
        GbActivityInfo gbActivityInfo = null;
        GbGroupJoin gbGroupJoin = null;
        if (!StringUtils.isEmpty(handleGroupRequestDto.getGbGroupId())) {
            gbGroupInfo = gbGroupInfoRepo.findOne(handleGroupRequestDto.getGbGroupId());
            gbActivityInfo = gbGroupInfo.getGbActivityInfo();
            int countNum = gbGroupJoinRepo.countByGbGroupInfoIdAndIsDelete(gbGroupInfo.getId(), false);
            if (countNum >= gbActivityInfo.getNumberNeed()) {
                gbGroupInfoHandleResponseDto.setStatus(GlobalContants.ResponseStatus.ERROR);
                gbGroupInfoHandleResponseDto.setResponseMsg("团人数已满");
                return gbGroupInfoHandleResponseDto;
            }
        } else if (!StringUtils.isEmpty(handleGroupRequestDto.getGbActivityInfoId())) {
            gbActivityInfo = gbActivityInfoRepo.findOne(handleGroupRequestDto.getGbActivityInfoId());
        }
        switch (handleGroupRequestDto.getActivityBuyWayDefinitionType()) {
            case gbSingleBuy:
                break;
            case createGbBuy:
                ActivityDefinition activityDefinition = gbActivityInfo.getActivityDefinition();
                gbGroupInfo = new GbGroupInfo();
                gbGroupInfo.setGbActivityInfo(gbActivityInfo);
                gbGroupInfo.setMemberId(handleGroupRequestDto.getMemberId());
                gbGroupInfo.setStatus(GbGroupInfoStatus.onGing.getCode());
                gbGroupInfo.setGroupStartTime(activityDefinition.getBeginTime());
                gbGroupInfo.setGroupEndTime(activityDefinition.getEndTime());
                gbGroupInfoRepo.saveAndFlush(gbGroupInfo);
                gbGroupJoin = getGbGroupJoin(handleGroupRequestDto, gbGroupInfo);
                gbGroupJoin.setIsLeader(true);
                gbGroupInfoHandleResponseDto.setGroupId(gbGroupInfo.getId());
                break;
            case gbBuy:
                gbGroupJoin = getGbGroupJoin(handleGroupRequestDto, gbGroupInfo);
                gbGroupJoin.setIsLeader(false);
                gbGroupInfoHandleResponseDto.setGroupId(gbGroupInfo.getId());
        }

        GbOrderInfo gbOrderInfo = new GbOrderInfo();
        gbOrderInfo.setTypeBuy(handleGroupRequestDto.getActivityBuyWayDefinitionType().getCode());
        gbOrderInfo.setOrderNo(handleGroupRequestDto.getOrderNo());
        gbOrderInfo.setChannel(handleGroupRequestDto.getChannel());
        if (gbGroupJoin != null) {
            gbGroupJoinRepo.saveAndFlush(gbGroupJoin);
            gbOrderInfo.setGbGroupJoin(gbGroupJoin);
        }
        gbOrderInfo.setGbActivityInfo(gbActivityInfo);
        if (gbGroupInfo != null && gbActivityInfo.getNumberNeed() <= gbGroupInfo.getNumberParticipation()) {
            gbGroupInfo.setStatus(GbGroupInfoStatus.finish.getCode());
            gbGroupInfoRepo.saveAndFlush(gbGroupInfo);
        }
        gbOrderInfoRepo.saveAndFlush(gbOrderInfo);
        return gbGroupInfoHandleResponseDto;
    }

    /**
     * 查询活动信息
     */
    @Override
    public GbActivityInfoRespDto queryGbActivityInfoRespDto(GbActivityInfoReqDto gbActivityInfoReqDto) {
        GbActivityInfoRespDto gbActivityInfoRespDto = new GbActivityInfoRespDto();
        GbActivityInfoDto gbActivityInfo = BeanMapper.map(gbActivityInfoRepo.findOne(gbActivityInfoReqDto.getActivityId()),GbActivityInfoDto.class);
        gbActivityInfoRespDto.setActivityDefinition(gbActivityInfo.getActivityDefinition());
        gbActivityInfoRespDto.setNumberNeed(gbActivityInfo.getNumberNeed());
        return gbActivityInfoRespDto;
    }

    @Override
    public BaseResponse gbPayback(PaymentReturnVo paymentReturnVo) {
        PayResultDto payResultDto = orderMainApi.finishPay(paymentReturnVo);
        List<String> orderNos = payResultDto.getOrderNos();
        if (orderNos != null && !orderNos.isEmpty()) {
            String orderNo = orderNos.get(0);
            GbOrderInfo orderInfo = gbOrderInfoRepo.findByOrderNoAndIsDelete(orderNo, false);
            OrderMainDto orderMain = orderMainApi.findByOrderNo(orderNo);
//            paymentApi.updatePaymentStatus(orderMain.getPaymentId(), Payment.PAY_STATUS_PAID);
            ActivityBuyWayDefinitionType activityBuyWayDefinitionType = ActivityBuyWayDefinitionType.activityBuyWayDefinitionTypeHashMap.get(orderInfo.getTypeBuy());
            switch (activityBuyWayDefinitionType) {
                case gbSingleBuy:
                    //单买直接下单
//                    Map<String, Object> returnMap = orderMainApi.occupyStock(orderMain);//预占库存
//                    if (!GlobalContants.ResponseStatus.SUCCESS.equals(returnMap.get("returnCode").toString())) {
//                        logger.error("预占库存失败，orderNo={}", orderNo);
//                        throw new RuntimeException("预占库存失败");
//                    }
                    orderMainApi.confirmOrder(orderNo);//确认预占库存
                    break;
                default:
                    GbGroupJoin gbGroupJoinCurrent = orderInfo.getGbGroupJoin();
                    GbGroupInfo gbGroupInfo = gbGroupJoinCurrent.getGbGroupInfo();
                    gbGroupJoinCurrent.setIsDelivery(true);
                    gbGroupJoinRepo.saveAndFlush(gbGroupJoinCurrent);
                    //团是否满人
                    if (GbGroupInfoStatus.finish.getCode().equals(gbGroupInfo.getStatus())) {
                        logger.info("团gbGroupInfo={}已满员", JSON.toJSONString(gbGroupInfo));
                        List<GbGroupJoin> gbGroupJoins = gbGroupJoinRepo.findByGbGroupInfoIdAndIsDeliveryAndIsDelete(gbGroupInfo.getId(), true, false);
                        //团支付人数是否满人
                        if (gbGroupJoins.size() >= gbGroupInfo.getNumberParticipation()) {
                            logger.info("团gbGroupInfo={}已全部支付，启动京东预占库存", JSON.toJSONString(gbGroupInfo));
                            gbGroupInfo.setStatus(GbGroupInfoStatus.payFinish.getCode());
                            gbGroupInfoRepo.saveAndFlush(gbGroupInfo);
                            for (GbGroupJoin gbGroupJoin : gbGroupJoins) {
                                List<GbOrderInfo> gbOrderInfos = gbOrderInfoRepo.findByGbGroupJoinId(gbGroupJoin.getId());
                                for (GbOrderInfo gbOrderInfo : gbOrderInfos) {
                                    orderMain = orderMainApi.findByOrderNo(gbOrderInfo.getOrderNo());
//                                    returnMap = orderMainApi.occupyStock(orderMain);
//                                    if (GlobalContants.ResponseStatus.SUCCESS.equals(returnMap.get("returnCode").toString())) {
                                        orderMainApi.confirmOrder(gbOrderInfo.getOrderNo());
                                        logger.info("==========预占库存成功，orderNo={}", orderNo);

//                                    } else {
//                                        logger.error("==========预占库存失败，orderNo={}", orderNo);
////                                        return new BaseResponse(GlobalContants.ResponseStatus.ERROR, "预占库存失败");
//                                        try {
//                                            MailReq mailReq = new MailReq();
//                                            mailReq.setSubject("拼团已支付订单预占库存失败");
//                                            String mailContent = "团号 groupId=：" + gbGroupInfo.getId() + "memberId=" + orderMain.getMemberId() + "orderNo=" + orderMain.getOrderNo() + "预占库存失败，请处理";
//                                            mailReq.setText(mailContent);
//                                            mailReq.setTo(new String[]{"chenchsh@sinosoft.com.cn", "chensrgz@sinosoft.com.cn", "zdc_q361@163.com"});
//                                            mailReq.setChannel(MailReq.CHANNEL_ITAIPING_MOBLE);
//                                            mailApi.sendMailAsync(mailReq);
//                                        } catch (Exception e) {
//                                            logger.error("拼团下单失，发送邮件失败orderNo{}", orderNo);
//                                        }
//                                    }

//                                    orderMainApi.updateOrderStatus(orderMain.getId(), OrderMain.order_status_finish_grouped);
                                }
                            }
                        } else {
                            orderMainApi.updateOrderStatus(orderMain.getId(), OrderMainDto.order_status_wait_for_group);
                        }
                    } else {
                        orderMainApi.updateOrderStatus(orderMain.getId(), OrderMainDto.order_status_wait_for_group);
                    }
            }
            return new BaseResponse(GlobalContants.ResponseStatus.SUCCESS, "支付回调成功");
        }
        return new BaseResponse(GlobalContants.ResponseStatus.ERROR, "支付回调失败");
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @Override
    public BaseResponse cancelGbOrder(GbOrderInfo gbOrderInfo) {
        if (gbOrderInfo != null) {
            gbOrderInfo = gbOrderInfoRepo.findOne(gbOrderInfo.getId());
            if (gbOrderInfo.getIsDelete()) {
                return new BaseResponse(GlobalContants.ResponseStatus.SUCCESS, "该订单已经取消，不能重复取消");
            }
            gbOrderInfo.setIsDelete(true);
            gbOrderInfoRepo.saveAndFlush(gbOrderInfo);
            GbGroupJoin gbGroupJoin = gbOrderInfo.getGbGroupJoin();
            if (gbGroupJoin != null && !gbGroupJoin.getIsDelete()) {
                gbGroupJoin.setIsDelete(true);
                gbGroupJoin.setIsDelivery(false);

                GbGroupInfo gbGroupInfo = gbGroupJoin.getGbGroupInfo();
                try {
                    gbGroupInfo.setNumberParticipation(gbGroupInfo.getNumberParticipation() - 1);
                    gbGroupInfo.setStatus(GbGroupInfoStatus.onGing.getCode());
                    gbGroupInfoRepo.saveAndFlush(gbGroupInfo);
                    gbGroupJoinRepo.saveAndFlush(gbGroupJoin);
                    String activity = gbGroupJoin.getGbGroupInfo().getGbActivityInfo().getActivityDefinition().getId();
                    if (activity != null) {
                        List<OrderItemDto> orderItemDtos = orderItemApi.findByOrderNo(gbOrderInfo.getOrderNo());
                        for (OrderItemDto orderItemDto : orderItemDtos) {
                            int downGoodsStock = activityGoodsRepos.countDownGoodsStock(activity, orderItemDto.getGoodsId(), 0-orderItemDto.getCount());
                            if (downGoodsStock == 0) {
                                logger.error("返还库存失败orderNo={},goodsId={}", gbOrderInfo.getOrderNo(), orderItemDto.getGoodsId());
                            }
                        }
                    }
                } catch (Exception e) {
                    logger.error("团购订单取消失败");
                    throw e;
                }
            }
        }
        return new BaseResponse(GlobalContants.ResponseStatus.SUCCESS, gbOrderInfo.getOrderNo(), "该订单不是拼团订单");
    }

    @Override
    public GbOrderInfo findByOrderNo(String orderNo) {
        return gbOrderInfoRepo.findByOrderNoAndIsDelete(orderNo, false);
    }

    @Override
    public GbOrderInfoDto queryGroupOrderInfo(String orderNo) {
        GbOrderInfoDto gbOrderInfoDto = new GbOrderInfoDto();
        GbOrderInfo orderInfo = findByOrderNo(orderNo);
        if (orderInfo != null) {
            gbOrderInfoDto.setGbChannel(orderInfo.getChannel());
            List<OrderItemDto> orderItemDtos = orderItemApi.findByOrderNo(orderNo);
            if (orderItemDtos != null) {
                gbOrderInfoDto.setGoodsId(orderItemDtos.get(0).getGoodsId());
            }
            if (orderInfo.getGbGroupJoin() != null) {
                gbOrderInfoDto.setGroupId(orderInfo.getGbGroupJoin().getGbGroupInfo().getId());
            }
//            gbOrderInfoDto
            gbOrderInfoDto.setActivityBuyWayDefinitionType(ActivityBuyWayDefinitionType.activityBuyWayDefinitionTypeHashMap.get(orderInfo.getTypeBuy()));
        }
        return gbOrderInfoDto;
    }

    @Override
    public String findOrderNoByMemberIdAndGroupId(String memberId, String groupId) {
        List<GbOrderInfo> gbOrderInfos = gbOrderInfoRepo.findByGbGroupJoinMemberIdAndGbGroupJoinGbGroupInfoIdAndIsDelete(memberId, groupId, false);
        if (gbOrderInfos != null && !gbOrderInfos.isEmpty()) {
            return gbOrderInfos.get(0).getOrderNo();
        }
        return null;
    }

    public GbGroupJoin getGbGroupJoin(GroupInfoHandleRequestDto handleGroupRequestDto, GbGroupInfo gbGroupInfo) {
        GbGroupJoin gbGroupJoin = new GbGroupJoin();
        gbGroupJoin.setGbGroupInfo(gbGroupInfo);
        gbGroupJoin.setDateJoin(new Date());
        gbGroupJoin.setMemberId(handleGroupRequestDto.getMemberId());
        gbGroupJoin.setIsDelivery(false);//支付后真正参团成功
        gbGroupInfo.setNumberParticipation(gbGroupInfo.getNumberParticipation() == null ? 1 : gbGroupInfo.getNumberParticipation() + 1);
        return gbGroupJoin;
    }

    /**
     * 定时扫描处理过期未成团的团
     */
    @Override
    public void queryActivityGroupStatusAndHandle() {
        logger.info("进入扫描过期待成团活动");
        try {
            //查询活动过期且未成团的团
            List<GbActivityInfo> gbActivity = gbActivityInfoRepo.findByActivityDefinitionEndTimeLessThanAndExpiredSynchronizeIsNull(DateUtils.addHours(new Date(), -2));
            if (gbActivity != null) {
                logger.info("开始扫描过期活动下待成团的团");
                for (GbActivityInfo gbActivityInfo : gbActivity) {
                    logger.info("===============活动信息============gbActivityInfo=" + gbActivityInfo);
                    //获取团信息
                    List<GbGroupInfo> gbGroupInfos = gbActivityInfo.getGbGroupInfos();
                    for (GbGroupInfo gbGroupInfo : gbGroupInfos) {
                        logger.info("===============团信息============gbGroupInfo=" + gbGroupInfo);
                        //活动过期未成团
                        if (GbGroupInfoStatus.onGing.getCode().equals(gbGroupInfo.getStatus()) || GbGroupInfoStatus.finish.getCode().equals(gbGroupInfo.getStatus())) {
                            List<GbGroupJoin> gbGroupJoins = gbGroupJoinRepo.findByGbGroupInfoIdAndIsDeliveryAndIsDelete(gbGroupInfo.getId(), true, false);
//                            List<String> orderNos = new ArrayList<>();
//                            Boolean isAllSuccess = true;
                            for (GbGroupJoin gbGroupJoin : gbGroupJoins) {
                                List<GbOrderInfo> gbOrderInfos = gbOrderInfoRepo.findByGbGroupJoinId(gbGroupJoin.getId());
                                if (gbOrderInfos != null) {
                                    GbOrderInfo gbOrderInfo = gbOrderInfos.get(0);
//                                }
//                                for (GbOrderInfo gbOrderInfo : gbOrderInfos) {
                                    logger.info("===============订单信息============gbOrderInfo=" + gbOrderInfo);
                                    if (!StringUtils.isEmpty(gbOrderInfo.getOrderNo())) {
                                        OrderMainDto orderMain = orderMainApi.findByOrderNo(gbOrderInfo.getOrderNo());
                                        if (orderMain != null) {
                                            //预占库存
                                            Map<String, Object> returnMap = orderMainApi.occupyStock(orderMain);
                                            PaymentDto paymentInfo = paymentApi.findPaymentById(orderMain.getPaymentId());
                                            if (PaymentDto.PAY_STATUS_PAID.equals(paymentInfo.getStatus())) {
//                                                if (GlobalContants.ResponseStatus.SUCCESS.equals(returnMap.get("returnCode").toString())) {
                                                    //确认预占库存
                                                    orderMainApi.confirmOrder(gbOrderInfo.getOrderNo());
//                                                isAllSuccess = false;
//                                                } else {
//                                                    logger.error("==========预占库存失败，orderNo={}", gbOrderInfo.getOrderNo());
//                                                    try {
//                                                        MailReq mailReq = new MailReq();
//                                                        mailReq.setSubject("拼团已支付订单预占库存失败");
//                                                        String mailContent = "团号 groupId=：" + gbGroupInfo.getId() + "memberId=" + orderMain.getMemberId() + "orderNo=" + orderMain.getOrderNo() + "预占库存失败，请处理";
//                                                        mailReq.setText(mailContent);
//                                                        mailReq.setTo(new String[]{"chenchsh@sinosoft.com.cn", "chensrgz@sinosoft.com.cn", "zdc_q361@163.com"});
//                                                        mailReq.setChannel(MailReq.CHANNEL_ITAIPING_MOBLE);
//                                                        mailApi.sendMailAsync(mailReq);
//                                                    } catch (Exception e) {
//                                                        logger.error("拼团预占库存失败，发送短信失败");
//                                                    }
//                                                }
//                                            orderNos.add(gbOrderInfo.getOrderNo());

                                                //orderMainApi.updateOrderStatus(orderMain.getId(), OrderMain.order_status_finish_grouped);
                                                logger.info("过期活动下待成团已确认预占库存");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    //更改活动状态为过期已确认预占库存
                    gbActivityInfo.setExpiredSynchronize(GbActivityStatus.expiredSynchronize.getCode());
                    gbActivityInfoRepo.saveAndFlush(gbActivityInfo);
                }
            }
        } catch (Exception e) {
            logger.error("扫描过期活动下待成团的团失败", e);
        }
    }
}